/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.wsdl;

import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.bom.BpelObject4WSDL;
import org.apache.ode.bpel.compiler.bom.BpelObjectFactory;
import org.apache.ode.bpel.compiler.bom.PartnerLinkType;
import org.apache.ode.bpel.compiler.bom.Property;
import org.apache.ode.bpel.compiler.bom.PropertyAlias;
import org.apache.ode.bpel.compiler.wsdl.Messages;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BpelExtensionSerializer
implements ExtensionDeserializer,
ExtensionSerializer {
    protected static final Messages __msgs = MessageBundle.getMessages(Messages.class);
    private BpelObjectFactory _factory;

    public BpelExtensionSerializer(BpelObjectFactory factory) {
        this._factory = factory;
    }

    public void marshall(Class arg0, QName arg1, ExtensibilityElement arg2, PrintWriter arg3, Definition arg4, ExtensionRegistry arg5) throws WSDLException {
        if ("partnerLinkType".equals(arg1.getLocalPart())) {
            String namespaceURI = arg1.getNamespaceURI();
            PartnerLinkType plink = (PartnerLinkType)arg2;
            StringBuffer sb = new StringBuffer();
            sb.append("<ns0:partnerLinkType");
            sb.append(" xmlns:ns0='").append(namespaceURI).append("'");
            sb.append(" xmlns:ns1='").append(plink.getName().getNamespaceURI()).append("'");
            sb.append(" name='ns1:").append(plink.getName().getLocalPart()).append("'>");
            for (PartnerLinkType.Role role : plink.getRoles()) {
                sb.append("<ns0:role");
                sb.append(" name='").append(role.getName()).append("'/>");
            }
            sb.append("</ns0:partnerLinkType>");
            arg3.write(sb.toString());
        } else if ("property".equals(arg1.getLocalPart())) {
            String namespaceURI = arg1.getNamespaceURI();
            Property property = (Property)arg2;
            StringBuffer sb = new StringBuffer();
            sb.append("<ns0:property");
            sb.append(" xmlns:ns0='").append(namespaceURI).append("'");
            sb.append(" xmlns:n1='").append(property.getType().getNamespaceURI()).append("'");
            sb.append(" type='").append("n1:").append(property.getType().getLocalPart()).append("'");
            sb.append("'/>");
            arg3.write(sb.toString());
        } else if ("propertyAlias".equals(arg1.getLocalPart())) {
            String namespaceURI = arg1.getNamespaceURI();
            PropertyAlias propertyAlias = (PropertyAlias)arg2;
            StringBuffer sb = new StringBuffer();
            sb.append("<ns0:propertyAlias");
            sb.append(" xmlns:ns0='").append(namespaceURI).append("'");
            sb.append(" xmlns:ns1='").append(propertyAlias.getPropertyName().getNamespaceURI()).append("'");
            sb.append(" propertyName='").append("ns1:").append(propertyAlias.getPropertyName().getLocalPart()).append("'");
            sb.append(" xmlns:ns2='").append(propertyAlias.getMessageType().getNamespaceURI()).append("'");
            sb.append(" messageType='").append("ns2:").append(propertyAlias.getMessageType().getLocalPart()).append("'");
            sb.append(" part='").append(propertyAlias.getPart()).append("'");
            sb.append("<ns0:query>");
            sb.append(propertyAlias.getQuery());
            sb.append("</ns0:query>");
            sb.append("</ns0:propertyAlias>");
            arg3.write(sb.toString());
        } else {
            throw new UnsupportedOperationException("Unknown element " + arg1);
        }
    }

    public ExtensibilityElement unmarshall(Class clsType, QName eltype, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        BpelObject4WSDL obj;
        BpelExtensionSerializer.validateExtensibilityElementContext(el);
        try {
            obj = (BpelObject4WSDL)this._factory.createBpelObject(el, new URI(def.getDocumentBaseURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        obj.setElementType(eltype);
        obj.setRequired(false);
        obj.setTargetNamespace(def.getTargetNamespace());
        return obj;
    }

    protected static QName derefQName(String prefixedQNameStr, Element context) throws WSDLException {
        String uri;
        int idx = prefixedQNameStr.indexOf(":");
        if (idx == -1) {
            uri = DOMUtils.getNamespaceURIFromPrefix(context, null);
        } else {
            if (idx >= prefixedQNameStr.length() || idx == 0) {
                String msg = __msgs.msgMalformedQName(prefixedQNameStr);
                throw new WSDLException("INVALID_WSDL", msg);
            }
            String prefix = prefixedQNameStr.substring(0, idx);
            uri = DOMUtils.getMyNSContext(context).getNamespaceURI(prefix);
            if (uri == null) {
                String msg = __msgs.msgInvalidNamespacePrefix(prefix);
                throw new WSDLException("INVALID_WSDL", msg);
            }
        }
        return new QName(uri, prefixedQNameStr.substring(idx + 1, prefixedQNameStr.length()));
    }

    static void validateExtensibilityElementContext(Element el) throws WSDLException {
        Node n = el.getParentNode();
        if (n == null || n.getNodeType() != 1) {
            WSDLException we = new WSDLException("OTHER_ERROR", __msgs.msgCannotBeDocumentRootElement(DOMUtils.getNodeQName(el).toString()));
            we.setLocation(XPathUtils.getXPathExprFromNode((Node)el));
            throw we;
        }
        Element def = (Element)n;
        if (def.getNamespaceURI() == null || !def.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !def.getLocalName().equals("definitions")) {
            WSDLException we = new WSDLException("OTHER_ERROR", __msgs.msgMustBeChildOfDef(DOMUtils.getNodeQName(el).toString()));
            we.setLocation(XPathUtils.getXPathExprFromNode((Node)el));
            throw we;
        }
    }

    protected String getAttribute(Element element, String attributeName) {
        Attr attribute = element.getAttributeNode(attributeName);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }
}

