/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BrokeredMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.InstanceLockManager;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MexDaoUtil;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.SharedEndpoints;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.BpelEngine;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.intercept.ProcessCountThrottler;
import org.apache.ode.bpel.intercept.ProcessSizeThrottler;
import org.apache.ode.bpel.o.OConstants;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.dao.bpel.MessageExchangeDAO;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BpelEngineImpl
implements BpelEngine {
    private static final Log __log = LogFactory.getLog(BpelEngineImpl.class);
    private Random _random = new Random(System.currentTimeMillis());
    private static double _delayMean = 0.0;
    private static final Messages __msgs;
    private static final double PROCESS_OVERHEAD_MEMORY_FACTOR = 1.2;
    public final HashMap<QName, BpelProcess> _activeProcesses = new HashMap();
    private final HashMap<QName, List<BpelProcess>> _serviceMap = new HashMap();
    private SharedEndpoints _sharedEps;
    private final InstanceLockManager _instanceLockManager = new InstanceLockManager();
    private boolean _useLocks = false;
    final Contexts _contexts;
    private final Map<QName, Long> _hydratedSizes = new HashMap<QName, Long>();
    private final Map<QName, Long> _unhydratedSizes = new HashMap<QName, Long>();
    private Properties _configProperties;
    private long _processThrottledMaximumSize = Long.MAX_VALUE;
    private int _processThrottledMaximumCount = Integer.MAX_VALUE;
    private int _instanceThrottledMaximumCount = Integer.MAX_VALUE;
    private boolean _hydrationThrottled = false;
    private boolean _xtsEnable = false;

    public BpelEngineImpl(Contexts contexts, Properties config) {
        this._contexts = contexts;
        this._sharedEps = new SharedEndpoints();
        this._sharedEps.init();
        this._configProperties = config;
        if (this._configProperties != null) {
            this._useLocks = this._configProperties.getProperty("explicit.instance.locks", Boolean.FALSE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
        }
    }

    public SharedEndpoints getSharedEndpoints() {
        return this._sharedEps;
    }

    public MyRoleMessageExchange createMessageExchange(String clientKey, QName targetService, String operation, String pipedMexId) throws BpelEngineException {
        List<BpelProcess> targets = this.route(targetService, null);
        ArrayList<BpelProcess> activeTargets = new ArrayList<BpelProcess>();
        if (targets == null || targets.size() == 0) {
            throw new BpelEngineException("NoSuchService: " + targetService);
        }
        for (BpelProcess target : targets) {
            if (target.getConf().getState() != ProcessState.ACTIVE) continue;
            activeTargets.add(target);
        }
        if (targets.size() == 1 || activeTargets.size() == 1) {
            BpelProcess target = activeTargets.size() == 1 ? (BpelProcess)activeTargets.get(0) : targets.get(0);
            return this.createNewMyRoleMex(target, clientKey, targetService, operation, pipedMexId);
        }
        BpelProcess template = (BpelProcess)activeTargets.get(0);
        ArrayList<MyRoleMessageExchange> meps = new ArrayList<MyRoleMessageExchange>();
        for (BpelProcess target : activeTargets) {
            meps.add(this.createNewMyRoleMex(target, clientKey, targetService, operation, pipedMexId));
        }
        return this.createNewMyRoleMex(template, meps);
    }

    private MyRoleMessageExchange createNewMyRoleMex(BpelProcess target, String clientKey, QName targetService, String operation, String pipedMexId) {
        MessageExchangeDAO dao = target == null || target.isInMemory() ? this._contexts.inMemDao.getConnection().createMessageExchange('M') : this._contexts.dao.getConnection().createMessageExchange('M');
        dao.setCorrelationId(clientKey);
        dao.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.UKNOWN_ENDPOINT.toString());
        dao.setPattern(MessageExchange.MessageExchangePattern.UNKNOWN.toString());
        dao.setCallee(targetService);
        dao.setStatus(MessageExchange.Status.NEW.toString());
        dao.setOperation(operation);
        dao.setPipedMessageExchangeId(pipedMexId);
        MyRoleMessageExchangeImpl mex = new MyRoleMessageExchangeImpl(target, this, dao);
        if (target != null) {
            target.initMyRoleMex(mex);
        }
        return mex;
    }

    private MyRoleMessageExchange createNewMyRoleMex(BpelProcess target, List<MyRoleMessageExchange> meps) throws BpelEngineException {
        MyRoleMessageExchangeImpl templateMex = (MyRoleMessageExchangeImpl)meps.get(0);
        MessageExchangeDAO templateMexDao = templateMex.getDAO();
        return new BrokeredMyRoleMessageExchangeImpl(target, this, meps, templateMexDao, templateMex);
    }

    @Override
    public MyRoleMessageExchange createMessageExchange(String clientKey, QName targetService, String operation) {
        return this.createMessageExchange(clientKey, targetService, operation, null);
    }

    private void setMessageExchangeProcess(String mexId, ProcessDAO processDao) {
        MessageExchangeDAO mexdao = this._contexts.inMemDao.getConnection().getMessageExchange(mexId);
        if (mexdao == null) {
            mexdao = this._contexts.dao.getConnection().getMessageExchange(mexId);
        }
        if (mexdao != null) {
            mexdao.setProcess(processDao);
        }
    }

    @Override
    public MessageExchange getMessageExchange(String mexId) {
        MessageExchangeImpl mex;
        MessageExchangeDAO mexdao = this._contexts.inMemDao.getConnection().getMessageExchange(mexId);
        if (mexdao == null) {
            mexdao = this._contexts.dao.getConnection().getMessageExchange(mexId);
        }
        if (mexdao == null) {
            return null;
        }
        ProcessDAO pdao = mexdao.getProcess();
        BpelProcess process = pdao == null ? null : this._activeProcesses.get(pdao.getProcessId());
        switch (mexdao.getDirection()) {
            case 'P': {
                if (process == null) {
                    String errmsg = __msgs.msgProcessNotActive(pdao.getProcessId());
                    __log.error((Object)errmsg);
                    throw new BpelEngineException(errmsg);
                }
                OPartnerLink plink = (OPartnerLink)process.getOProcess().getChild(mexdao.getPartnerLinkModelId());
                PortType ptype = plink.partnerRolePortType;
                Operation op = plink.getPartnerRoleOperation(mexdao.getOperation());
                mex = this.createPartnerRoleMessageExchangeImpl(mexdao, ptype, op, plink, process);
                break;
            }
            case 'M': {
                OPartnerLink plink;
                mex = new MyRoleMessageExchangeImpl(process, this, mexdao);
                if (process == null || (plink = (OPartnerLink)process.getOProcess().getChild(mexdao.getPartnerLinkModelId())) == null) break;
                PortType ptype = plink.myRolePortType;
                Operation op = plink.getMyRoleOperation(mexdao.getOperation());
                mex.setPortOp(ptype, op);
                break;
            }
            default: {
                String errmsg = "BpelEngineImpl: internal error, invalid MexDAO direction: " + mexId;
                __log.fatal((Object)errmsg);
                throw new BpelEngineException(errmsg);
            }
        }
        return mex;
    }

    protected PartnerRoleMessageExchangeImpl createPartnerRoleMessageExchangeImpl(MessageExchangeDAO mexdao, PortType ptype, Operation op, OPartnerLink plink, BpelProcess process) {
        return new PartnerRoleMessageExchangeImpl(this, mexdao, ptype, op, null, plink.hasMyRole() ? process.getInitialMyRoleEPR(plink) : null, process.getPartnerRoleChannel(plink));
    }

    public BpelProcess unregisterProcess(QName process) {
        BpelProcess p = this._activeProcesses.remove(process);
        __log.debug((Object)("Unregister process: serviceId=" + process + ", process=" + p));
        if (p != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Deactivating process " + p.getPID()));
            }
            Iterator<List<BpelProcess>> serviceIter = this._serviceMap.values().iterator();
            while (serviceIter.hasNext()) {
                Iterator<BpelProcess> entryProcesses = serviceIter.next().iterator();
                while (entryProcesses.hasNext()) {
                    BpelProcess entryProcess = entryProcesses.next();
                    if (!entryProcess.getPID().equals(process)) continue;
                    entryProcesses.remove();
                }
            }
            p.deactivate();
            p.dehydrate();
            this._hydratedSizes.remove(p.getPID());
        }
        return p;
    }

    boolean isProcessRegistered(QName pid) {
        return this._activeProcesses.containsKey(pid);
    }

    public BpelProcess getProcess(QName pid) {
        return this._activeProcesses.get(pid);
    }

    public void registerProcess(BpelProcess process) {
        this._activeProcesses.put(process.getPID(), process);
        for (Endpoint e : process.getServiceNames()) {
            __log.debug((Object)("Register process: serviceId=" + e + ", process=" + process));
            List<BpelProcess> processes = this._serviceMap.get(e.serviceName);
            if (processes == null) {
                processes = new ArrayList<BpelProcess>();
                this._serviceMap.put(e.serviceName, processes);
            }
            Iterator<BpelProcess> processesIter = processes.iterator();
            while (processesIter.hasNext()) {
                BpelProcess cachedVersion = processesIter.next();
                __log.debug((Object)("cached version " + cachedVersion.getPID() + " vs registering version " + process.getPID()));
                if (!cachedVersion.getProcessType().equals(process.getProcessType())) continue;
                if (cachedVersion.getVersion() > process.getVersion()) {
                    __log.debug((Object)"deactivating current version");
                    process.activate(this);
                    process.deactivate();
                    return;
                }
                __log.debug((Object)"removing cached older version");
                processesIter.remove();
                cachedVersion.deactivate();
            }
            processes.add(process);
        }
        process.activate(this);
    }

    List<BpelProcess> route(QName service, Message request) {
        List<BpelProcess> routed = this._serviceMap.get(service);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Routed: svcQname " + service + " --> " + routed));
        }
        return routed;
    }

    OProcess getOProcess(QName processId) {
        BpelProcess process = this._activeProcesses.get(processId);
        if (process == null) {
            return null;
        }
        return process.getOProcess();
    }

    public void acquireInstanceLock(final Long iid) {
        if (!this._useLocks) {
            return;
        }
        try {
            this._instanceLockManager.lock(iid, 1, TimeUnit.MICROSECONDS);
            this._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                @Override
                public void afterCompletion(boolean success) {
                    BpelEngineImpl.this._instanceLockManager.unlock(iid);
                }

                @Override
                public void beforeCompletion() {
                }
            });
        }
        catch (InterruptedException e) {
            __log.debug((Object)"Thread interrupted, job will be rescheduled");
            throw new Scheduler.JobProcessorException(true);
        }
        catch (InstanceLockManager.TimeoutException e) {
            __log.debug((Object)("Instance " + iid + " is busy, rescheduling job."));
            throw new Scheduler.JobProcessorException(true);
        }
    }

    @Override
    public void onScheduledJob(Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("[JOB] onScheduledJob " + jobInfo + "" + jobInfo.jobDetail.getInstanceId()));
        }
        this.onScheduledJob(jobInfo.jobDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onScheduledJob(Scheduler.JobDetails we) {
        this.acquireInstanceLock(we.getInstanceId());
        BpelProcess process = null;
        try {
            if (we.getProcessId() != null) {
                process = this._activeProcesses.get(we.getProcessId());
            } else {
                ProcessInstanceDAO instance = we.getInMem() != false ? this._contexts.inMemDao.getConnection().getInstance(we.getInstanceId()) : this._contexts.dao.getConnection().getInstance(we.getInstanceId());
                if (instance == null) {
                    __log.debug((Object)__msgs.msgScheduledJobReferencesUnknownInstance(we.getInstanceId()));
                    return;
                }
                ProcessDAO processDao = instance.getProcess();
                process = this._activeProcesses.get(processDao.getProcessId());
            }
            if (process == null) {
                __log.debug((Object)("Process " + we.getProcessId() + " can't be found, job abandoned."));
                return;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(process._classLoader);
                if (we.getType().equals((Object)Scheduler.JobType.INVOKE_CHECK)) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("handleJobDetails: InvokeCheck event for mexid " + we.getMexId()));
                    }
                    this.sendPartnerRoleFailure(we, MessageExchange.FailureType.COMMUNICATION_ERROR);
                    return;
                }
                if (we.getType().equals((Object)Scheduler.JobType.INVOKE_INTERNAL)) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("handleJobDetails: InvokeInternal event for mexid " + we.getMexId()));
                    }
                    this.setMessageExchangeProcess(we.getMexId(), process.getProcessDAO());
                    MyRoleMessageExchangeImpl mex = (MyRoleMessageExchangeImpl)this.getMessageExchange(we.getMexId());
                    if (!process.processInterceptors(mex, InterceptorInvoker.__onJobScheduled)) {
                        boolean isTwoWay = Boolean.valueOf(mex.getProperty("isTwoWay"));
                        if (isTwoWay) {
                            String causeCodeValue = mex.getProperty("causeCode");
                            mex.getDAO().setProcess(process.getProcessDAO());
                            this.sendMyRoleFault(process, we, causeCodeValue != null ? Integer.valueOf(causeCodeValue) : 0);
                            return;
                        }
                        throw new Scheduler.JobProcessorException(this.checkRetry(we));
                    }
                }
                process.handleJobDetails(we);
                this.debuggingDelay();
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (Scheduler.JobProcessorException e) {
            throw e;
        }
        catch (BpelEngineException bee) {
            __log.error((Object)__msgs.msgScheduledJobFailed(we), (Throwable)bee);
            throw new Scheduler.JobProcessorException(bee, this.checkRetry(we));
        }
        catch (ContextException ce) {
            __log.error((Object)__msgs.msgScheduledJobFailed(we), (Throwable)ce);
            throw new Scheduler.JobProcessorException(ce, this.checkRetry(we));
        }
        catch (InvalidProcessException ipe) {
            __log.error((Object)__msgs.msgScheduledJobFailed(we), (Throwable)ipe);
            this.sendMyRoleFault(process, we, ipe.getCauseCode());
        }
        catch (RuntimeException rte) {
            __log.error((Object)__msgs.msgScheduledJobFailed(we), (Throwable)rte);
            throw new Scheduler.JobProcessorException(rte, this.checkRetry(we));
        }
        catch (Throwable t) {
            __log.error((Object)__msgs.msgScheduledJobFailed(we), t);
            throw new Scheduler.JobProcessorException(t, this.checkRetry(we));
        }
    }

    private boolean checkRetry(Scheduler.JobDetails we) {
        return we.getInMem() == false;
    }

    private void debuggingDelay() {
        if (_delayMean != 0.0) {
            try {
                long delay = this.randomExp(_delayMean);
                __log.warn((Object)("Debugging delay has been activated; delaying transaction for " + delay + "ms."));
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private long randomExp(double mean) {
        double u = this._random.nextDouble();
        long delay = (long)(-Math.log(u) * mean);
        return delay;
    }

    void fireEvent(BpelEvent event) {
        for (BpelEventListener l : this._contexts.eventListeners) {
            l.onEvent(event);
        }
    }

    List<MessageExchangeInterceptor> getGlobalInterceptors() {
        return this._contexts.globalInterceptors;
    }

    public void registerMessageExchangeInterceptor(MessageExchangeInterceptor interceptor) {
        this._contexts.globalInterceptors.add(interceptor);
    }

    public void unregisterMessageExchangeInterceptor(MessageExchangeInterceptor interceptor) {
        this._contexts.globalInterceptors.remove(interceptor);
    }

    public void unregisterMessageExchangeInterceptor(Class interceptorClass) {
        MessageExchangeInterceptor candidate = null;
        for (MessageExchangeInterceptor interceptor : this._contexts.globalInterceptors) {
            if (!interceptor.getClass().isAssignableFrom(interceptorClass)) continue;
            candidate = interceptor;
            break;
        }
        if (candidate != null) {
            this._contexts.globalInterceptors.remove(candidate);
        }
    }

    public long getTotalBpelFootprint() {
        long bpelFootprint = 0L;
        for (BpelProcess process : this._activeProcesses.values()) {
            Long size = this._hydratedSizes.get(process.getPID());
            if (size == null) {
                size = this._unhydratedSizes.get(process.getPID());
            }
            if (size == null || size <= 0L) continue;
            bpelFootprint += size.longValue();
        }
        return bpelFootprint;
    }

    public long getHydratedFootprint() {
        long hydratedFootprint = 0L;
        for (BpelProcess process : this._activeProcesses.values()) {
            if (!process.hintIsHydrated()) continue;
            Long size = this._hydratedSizes.get(process.getPID());
            if (size == null) {
                size = this._unhydratedSizes.get(process.getPID());
            }
            if (size == null || size <= 0L) continue;
            hydratedFootprint += size.longValue();
        }
        return hydratedFootprint;
    }

    @Override
    public long getHydratedProcessSize(QName processName) {
        return this.getHydratedProcessSize(this._activeProcesses.get(processName));
    }

    private long getHydratedProcessSize(BpelProcess process) {
        long potentialGrowth = 0L;
        if (!process.hintIsHydrated()) {
            Long mySize = this._hydratedSizes.get(process.getPID());
            if (mySize == null) {
                mySize = this._unhydratedSizes.get(process.getPID());
            }
            if (mySize != null && mySize > 0L) {
                potentialGrowth = mySize;
            }
        }
        return this.getHydratedProcessSize(potentialGrowth);
    }

    private long getHydratedProcessSize(long potentialGrowth) {
        long processMemory = (long)((double)(this.getHydratedFootprint() + potentialGrowth) * 1.2);
        return processMemory;
    }

    @Override
    public int getHydratedProcessCount(QName processName) {
        int processCount = 0;
        for (BpelProcess process : this._activeProcesses.values()) {
            if (!process.hintIsHydrated() && !process.getPID().equals(processName)) continue;
            ++processCount;
        }
        return processCount;
    }

    public void setInstanceThrottledMaximumCount(int instanceThrottledMaximumCount) {
        this._instanceThrottledMaximumCount = instanceThrottledMaximumCount;
    }

    public int getInstanceThrottledMaximumCount() {
        return this._instanceThrottledMaximumCount;
    }

    public void setProcessThrottledMaximumCount(int hydrationThrottledMaximumCount) {
        this._processThrottledMaximumCount = hydrationThrottledMaximumCount;
        if (hydrationThrottledMaximumCount < Integer.MAX_VALUE) {
            this.registerMessageExchangeInterceptor(new ProcessCountThrottler());
        } else {
            this.unregisterMessageExchangeInterceptor(ProcessCountThrottler.class);
        }
    }

    @Override
    public int getProcessThrottledMaximumCount() {
        return this._processThrottledMaximumCount;
    }

    public void setProcessThrottledMaximumSize(long hydrationThrottledMaximumSize) {
        this._processThrottledMaximumSize = hydrationThrottledMaximumSize;
        if (hydrationThrottledMaximumSize < Long.MAX_VALUE) {
            this.registerMessageExchangeInterceptor(new ProcessSizeThrottler());
        } else {
            this.unregisterMessageExchangeInterceptor(ProcessSizeThrottler.class);
        }
    }

    @Override
    public long getProcessThrottledMaximumSize() {
        return this._processThrottledMaximumSize;
    }

    public void setProcessSize(QName processId, boolean hydratedOnce) {
        BpelProcess process = this._activeProcesses.get(processId);
        long processSize = process.sizeOf();
        if (hydratedOnce) {
            this._hydratedSizes.put(process.getPID(), new Long(processSize));
            this._unhydratedSizes.remove(process.getPID());
        } else {
            this._hydratedSizes.remove(process.getPID());
            this._unhydratedSizes.put(process.getPID(), new Long(processSize));
        }
    }

    public void setXTSEnable(boolean xtsEnable) {
        this._xtsEnable = xtsEnable;
    }

    public boolean isXTSEnable() {
        return this._xtsEnable;
    }

    @Override
    public boolean dehydrateLastUnusedProcess() {
        BpelProcess lastUnusedProcess = null;
        long lastUsedMinimum = Long.MAX_VALUE;
        for (BpelProcess process : this._activeProcesses.values()) {
            if (!process.hintIsHydrated() || process.getLastUsed() >= lastUsedMinimum || process.getInstanceInUseCount() != 0) continue;
            lastUsedMinimum = process.getLastUsed();
            lastUnusedProcess = process;
        }
        if (lastUnusedProcess != null) {
            lastUnusedProcess.dehydrate();
            return true;
        }
        return false;
    }

    public void sendMyRoleFault(BpelProcess process, Scheduler.JobDetails we, int causeCode) {
        MessageExchange mex = this.getMessageExchange(we.getMexId());
        if (!(mex instanceof MyRoleMessageExchange)) {
            return;
        }
        QName faultQName = null;
        OConstants constants = process.getOProcess().constants;
        if (constants != null) {
            Document document = DOMUtils.newDocument();
            Element faultElement = document.createElementNS(Namespaces.SOAP_ENV_NS, "Fault");
            Element faultDetail = document.createElementNS(Namespaces.ODE_EXTENSION_NS, "fault");
            faultElement.appendChild(faultDetail);
            switch (causeCode) {
                case 3: {
                    faultQName = constants.qnTooManyProcesses;
                    faultDetail.setTextContent("The total number of processes in use is over the limit.");
                    break;
                }
                case 4: {
                    faultQName = constants.qnTooHugeProcesses;
                    faultDetail.setTextContent("The total size of processes in use is over the limit");
                    break;
                }
                case 2: {
                    faultQName = constants.qnTooManyInstances;
                    faultDetail.setTextContent("No more instances of the process allowed at start at this time.");
                    break;
                }
                case 1: {
                    for (BpelProcess activeProcess : this._activeProcesses.values()) {
                        if (!activeProcess.getConf().getState().equals(ProcessState.ACTIVE) || !activeProcess.getConf().getType().equals(process.getConf().getType())) continue;
                        we.setProcessId(activeProcess._pid);
                        ((MyRoleMessageExchangeImpl)mex)._process = activeProcess;
                        process.handleJobDetails(we);
                        return;
                    }
                    faultQName = constants.qnRetiredProcess;
                    faultDetail.setTextContent("The process you are trying to instantiate has been retired. Retired process can not take any new instance creation.");
                    break;
                }
                default: {
                    faultQName = constants.qnUnknownFault;
                }
            }
            MexDaoUtil.setFaulted((MessageExchangeImpl)mex, faultQName, faultElement);
        }
    }

    private void sendPartnerRoleFailure(Scheduler.JobDetails we, MessageExchange.FailureType failureType) {
        MessageExchange mex = this.getMessageExchange(we.getMexId());
        if (mex instanceof PartnerRoleMessageExchange && (mex.getStatus() == MessageExchange.Status.ASYNC || mex.getStatus() == MessageExchange.Status.REQUEST)) {
            String msg = "No response received for invoke (mexId=" + we.getMexId() + "), forcing it into a failed state.";
            if (__log.isDebugEnabled()) {
                __log.debug((Object)msg);
            }
            MexDaoUtil.setFailure((PartnerRoleMessageExchangeImpl)mex, failureType, msg, null);
        }
    }

    public BpelProcess getNewestProcessByType(QName processType) {
        long v = -1L;
        BpelProcess q = null;
        for (BpelProcess p : this._activeProcesses.values()) {
            if (!p.getProcessType().equals(processType) || v >= p.getVersion()) continue;
            v = p.getVersion();
            q = p;
        }
        return q;
    }

    static {
        try {
            String delay = System.getenv("ODE_DEBUG_TX_DELAY");
            if (delay != null && delay.length() > 0) {
                _delayMean = Double.valueOf(delay);
                __log.info((Object)("Stochastic debugging delay activated. Delay (Mean)=" + _delayMean + "ms."));
            }
        }
        catch (Throwable t) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Could not read ODE_DEBUG_TX_DELAY environment variable; assuming 0 (mean) delay", t);
            }
            __log.info((Object)"Could not read ODE_DEBUG_TX_DELAY environment variable; assuming 0 (mean) delay");
        }
        __msgs = MessageBundle.getMessages(Messages.class);
    }
}

