/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsl;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsl.XslTransformException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XslTransformHandler {
    private static final Log __log = LogFactory.getLog(XslTransformHandler.class);
    private static XslTransformHandler __singleton;
    private TransformerFactory _transformerFactory = null;
    private final MultiKeyMap _templateCache = new MultiKeyMap();

    public static synchronized XslTransformHandler getInstance() {
        if (__singleton == null) {
            __singleton = new XslTransformHandler();
        }
        return __singleton;
    }

    private XslTransformHandler() {
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this._transformerFactory = transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseXSLSheet(QName processQName, URI uri, String body, URIResolver resolver) {
        Templates tm;
        try {
            this._transformerFactory.setURIResolver(resolver);
            tm = this._transformerFactory.newTemplates(new StreamSource(new StringReader(body)));
        }
        catch (TransformerConfigurationException e) {
            throw new XslTransformException(e);
        }
        MultiKeyMap multiKeyMap = this._templateCache;
        synchronized (multiKeyMap) {
            this._templateCache.put((Object)processQName, (Object)uri, (Object)tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheXSLSheet(QName processQName, URI uri, String body, URIResolver resolver) {
        Templates tm;
        MultiKeyMap multiKeyMap = this._templateCache;
        synchronized (multiKeyMap) {
            tm = (Templates)this._templateCache.get((Object)processQName, (Object)uri);
        }
        if (tm == null) {
            this.parseXSLSheet(processQName, uri, body, resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(QName processQName, URI uri, Source source, Map<QName, Object> parameters, URIResolver resolver) {
        Templates tm;
        MultiKeyMap multiKeyMap = this._templateCache;
        synchronized (multiKeyMap) {
            tm = (Templates)this._templateCache.get((Object)processQName, (Object)uri);
        }
        if (tm == null) {
            throw new XslTransformException("XSL sheet" + uri + " has not been parsed before transformation!");
        }
        try {
            String method;
            Transformer tf = tm.newTransformer();
            tf.setURIResolver(resolver);
            if (parameters != null) {
                for (Map.Entry<QName, Object> param : parameters.entrySet()) {
                    tf.setParameter(param.getKey().getLocalPart(), param.getValue());
                }
            }
            if ((method = tf.getOutputProperties().getProperty("method")) == null || "xml".equals(method)) {
                DOMResult result = new DOMResult();
                tf.transform(source, result);
                Node node = result.getNode();
                if (node.getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Returned node: type=" + node.getNodeType() + ", " + DOMUtils.domToString(node)));
                }
                return node;
            }
            StringWriter writerResult = new StringWriter();
            StreamResult result = new StreamResult(writerResult);
            tf.transform(source, result);
            writerResult.flush();
            String output = writerResult.toString();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Returned string: " + output));
            }
            return output;
        }
        catch (TransformerConfigurationException e) {
            throw new XslTransformException(e);
        }
        catch (TransformerException e) {
            throw new XslTransformException("XSL Transformation failed!", e);
        }
    }

    public void setErrorListener(ErrorListener l) {
        this._transformerFactory.setErrorListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearXSLSheets(QName processQName) {
        MultiKeyMap multiKeyMap = this._templateCache;
        synchronized (multiKeyMap) {
            this._templateCache.removeAll((Object)processQName);
        }
    }
}

