/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.apache.camel.CamelContext;

public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private CamelContext camelContext;

    public ClassLoadingAwareObjectInputStream(CamelContext camelContext, InputStream in) throws IOException {
        super(in);
        this.camelContext = camelContext;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        return this.camelContext.getClassResolver().resolveClass(classDesc.getName());
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.camelContext.getClassResolver().resolveClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(cinterfaces[0].getClassLoader(), cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

