/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jpa;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jpa.JpaHelper;
import org.apache.camel.processor.idempotent.jpa.MessageProcessed;
import org.apache.camel.spi.ExchangeIdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@ManagedResource(description="JPA based message id repository")
public class JpaMessageIdRepository
extends ServiceSupport
implements ExchangeIdempotentRepository<String> {
    protected static final String QUERY_STRING = "select x from " + MessageProcessed.class.getName() + " x where x.processorName = ?1 and x.messageId = ?2";
    private static final Logger LOG = LoggerFactory.getLogger(JpaMessageIdRepository.class);
    private final String processorName;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionTemplate transactionTemplate;
    private boolean joinTransaction = true;

    public JpaMessageIdRepository(EntityManagerFactory entityManagerFactory, String processorName) {
        this(entityManagerFactory, JpaMessageIdRepository.createTransactionTemplate(entityManagerFactory), processorName);
    }

    public JpaMessageIdRepository(EntityManagerFactory entityManagerFactory, TransactionTemplate transactionTemplate, String processorName) {
        this.entityManagerFactory = entityManagerFactory;
        this.processorName = processorName;
        this.transactionTemplate = transactionTemplate;
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(String persistenceUnit, String processorName) {
        return JpaMessageIdRepository.jpaMessageIdRepository(Persistence.createEntityManagerFactory((String)persistenceUnit), processorName);
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(EntityManagerFactory entityManagerFactory, String processorName) {
        return new JpaMessageIdRepository(entityManagerFactory, processorName);
    }

    private static TransactionTemplate createTransactionTemplate(EntityManagerFactory entityManagerFactory) {
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager((PlatformTransactionManager)new JpaTransactionManager(entityManagerFactory));
        transactionTemplate.setPropagationBehavior(0);
        return transactionTemplate;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String messageId) {
        return this.add(null, messageId);
    }

    public boolean add(Exchange exchange, final String messageId) {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true);
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                List list;
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                if ((list = JpaMessageIdRepository.this.query(entityManager, messageId)).isEmpty()) {
                    MessageProcessed processed = new MessageProcessed();
                    processed.setProcessorName(JpaMessageIdRepository.this.processorName);
                    processed.setMessageId(messageId);
                    processed.setCreatedAt(new Date());
                    entityManager.persist((Object)processed);
                    entityManager.flush();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        LOG.debug("add {} -> {}", (Object)messageId, (Object)rc);
        return rc;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String messageId) {
        return this.contains(null, messageId);
    }

    public boolean contains(Exchange exchange, final String messageId) {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true);
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                List list;
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                if ((list = JpaMessageIdRepository.this.query(entityManager, messageId)).isEmpty()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        LOG.debug("contains {} -> {}", (Object)messageId, (Object)rc);
        return rc;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String messageId) {
        return this.remove(null, messageId);
    }

    public boolean remove(Exchange exchange, final String messageId) {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true);
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                List list;
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                if ((list = JpaMessageIdRepository.this.query(entityManager, messageId)).isEmpty()) {
                    return Boolean.FALSE;
                }
                MessageProcessed processed = (MessageProcessed)list.get(0);
                entityManager.remove((Object)processed);
                entityManager.flush();
                return Boolean.TRUE;
            }
        });
        LOG.debug("remove {}", (Object)messageId);
        return rc;
    }

    public boolean confirm(String messageId) {
        return this.confirm(null, messageId);
    }

    public boolean confirm(Exchange exchange, String messageId) {
        LOG.debug("confirm {} -> true", (Object)messageId);
        return true;
    }

    private List<?> query(EntityManager entityManager, String messageId) {
        Query query = entityManager.createQuery(QUERY_STRING);
        query.setParameter(1, (Object)this.processorName);
        query.setParameter(2, (Object)messageId);
        return query.getResultList();
    }

    @ManagedAttribute(description="The processor name")
    public String getProcessorName() {
        return this.processorName;
    }

    @ManagedAttribute(description="Whether to join existing transaction")
    public boolean isJoinTransaction() {
        return this.joinTransaction;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

