/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.service.guard.impl;

import java.util.Collection;
import java.util.Iterator;
import org.apache.karaf.service.guard.impl.GuardProxyCatalog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuardingFindHook
implements FindHook {
    private final BundleContext bundleContext;
    private final GuardProxyCatalog guardProxyCatalog;
    private final Filter servicesFilter;

    GuardingFindHook(BundleContext bundleContext, GuardProxyCatalog guardProxyCatalog, Filter securedServicesFilter) {
        this.bundleContext = bundleContext;
        this.guardProxyCatalog = guardProxyCatalog;
        this.servicesFilter = securedServicesFilter;
    }

    public void find(BundleContext bundleContext, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
        if (this.servicesFilter == null) {
            return;
        }
        if (this.bundleContext.equals(bundleContext) || bundleContext.getBundle().getBundleId() == 0L) {
            return;
        }
        Iterator<ServiceReference<?>> i = references.iterator();
        while (i.hasNext()) {
            ServiceReference<?> sr = i.next();
            if (!this.servicesFilter.match(sr) || !this.guardProxyCatalog.handleProxificationForHook(sr)) continue;
            i.remove();
        }
    }
}

