/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.bean.CommonBean;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.logging.SerializationLogger;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.Preconditions;

public class BeanIdentifierIndex
implements Service {
    private volatile BeanIdentifier[] index;
    private volatile Map<BeanIdentifier, Integer> reverseIndex;
    private volatile Integer indexHash;

    public Integer getIndex(BeanIdentifier identifier) {
        this.checkIsBuilt();
        Preconditions.checkArgumentNotNull(identifier, "identifier");
        return this.reverseIndex.get(identifier);
    }

    public BeanIdentifier getIdentifier(int idx) {
        this.checkIsBuilt();
        if (idx < 0 || idx >= this.index.length) {
            throw SerializationLogger.LOG.unableToGetBeanIdentifier(idx, this.getDebugInfo());
        }
        return this.index[idx];
    }

    public Integer getIndexHash() {
        return this.indexHash;
    }

    public void build(Set<Bean<?>> beans) {
        if (this.isBuilt()) {
            throw new IllegalStateException("BeanIdentifier index is already built!");
        }
        if (beans.isEmpty()) {
            this.index = new BeanIdentifier[0];
            this.reverseIndex = Collections.emptyMap();
            this.indexHash = 0;
            return;
        }
        ArrayList<BeanIdentifier> tempIndex = new ArrayList<BeanIdentifier>(beans.size());
        for (Bean<?> bean : beans) {
            if (bean instanceof CommonBean) {
                tempIndex.add(((CommonBean)bean).getIdentifier());
                continue;
            }
            if (!(bean instanceof PassivationCapable)) continue;
            tempIndex.add(new StringBeanIdentifier(((PassivationCapable)bean).getId()));
        }
        Collections.sort(tempIndex, new Comparator<BeanIdentifier>(){

            @Override
            public int compare(BeanIdentifier o1, BeanIdentifier o2) {
                return o1.asString().compareTo(o2.asString());
            }
        });
        this.index = tempIndex.toArray(new BeanIdentifier[tempIndex.size()]);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < this.index.length; ++i) {
            builder.put((Object)this.index[i], (Object)i);
        }
        this.reverseIndex = builder.build();
        this.indexHash = Arrays.hashCode(this.index);
        if (BootstrapLogger.LOG.isDebugEnabled()) {
            BootstrapLogger.LOG.beanIdentifierIndexBuilt(this.getDebugInfo());
        }
    }

    public boolean isBuilt() {
        return this.index != null;
    }

    public boolean isEmpty() {
        return this.index.length == 0;
    }

    @Override
    public void cleanup() {
        this.index = null;
    }

    private void checkIsBuilt() {
        if (!this.isBuilt()) {
            throw new IllegalStateException("BeanIdentifier index not built!");
        }
    }

    public String toString() {
        return String.format("BeanIdentifierIndex [hash=%s, indexed=%s]", this.indexHash, this.index.length);
    }

    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toString());
        builder.append(" \n");
        for (int i = 0; i < this.index.length; ++i) {
            builder.append("  ");
            builder.append(String.format("%4d", i));
            builder.append(": ");
            builder.append(this.index[i]);
            builder.append("\n");
        }
        return builder.toString();
    }
}

