/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.URLTemplateLoader;
import freemarker.template.utility.StringUtil;
import java.net.URL;

public class ClassTemplateLoader
extends URLTemplateLoader {
    private Class baseClass;
    private String packagePath;

    public ClassTemplateLoader() {
        this.setFields(this.getClass(), "/");
    }

    public ClassTemplateLoader(Class baseClass) {
        this.setFields(baseClass, "");
    }

    public ClassTemplateLoader(Class baseClass, String packagePath) {
        this.setFields(baseClass, packagePath);
    }

    protected URL getURL(String name) {
        String fullPath = this.packagePath + name;
        if (this.packagePath.equals("/") && !ClassTemplateLoader.isSchemeless(fullPath)) {
            return null;
        }
        return this.baseClass.getResource(fullPath);
    }

    private static boolean isSchemeless(String fullPath) {
        int i = 0;
        int ln = fullPath.length();
        if (i < ln && fullPath.charAt(i) == '/') {
            ++i;
        }
        while (i < ln) {
            char c = fullPath.charAt(i);
            if (c == '/') {
                return true;
            }
            if (c == ':') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void setFields(Class baseClass, String packagePath) {
        if (baseClass == null) {
            throw new IllegalArgumentException("baseClass == null");
        }
        if (packagePath == null) {
            throw new IllegalArgumentException("path == null");
        }
        this.baseClass = baseClass;
        this.packagePath = ClassTemplateLoader.canonicalizePrefix(packagePath);
    }

    public String toString() {
        return "ClassTemplateLoader(baseClass=" + this.baseClass.getName() + ", packagePath=" + StringUtil.jQuote(this.packagePath) + ")";
    }
}

