/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.switchyard.admin.Application;
import org.switchyard.admin.Reference;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;
import org.switchyard.deploy.karaf.PrintUtil;

@Command(scope="switchyard", name="read-reference", description="Returns a details about a SwitchYard reference deployed on the system.")
public class ReadReferenceCommand
extends AbstractSwitchYardServiceCommand {
    @Option(name="--application", aliases={"-a"}, description="If specified, only details for the named application are returned.", multiValued=true)
    private List<String> _applicationNames;
    @Option(name="--reference", aliases={"-r"}, description="If specified, only details for the named reference are returned.", multiValued=true)
    private List<String> _referenceNames;
    @Option(name="--regex", description="If specified, treat the name(s) as a regular expression.")
    private boolean _regex;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        Pattern applicationPattern = this.compilePattern(this._applicationNames, this._regex);
        Pattern referencePattern = this.compilePattern(this._referenceNames, this._regex);
        for (Application application : switchYard.getApplications()) {
            String applicationName = application.getName().toString();
            Matcher applicationMatcher = applicationPattern.matcher(applicationName);
            if (!applicationMatcher.find()) continue;
            System.out.println(application.getName() + " = [");
            for (Reference reference : application.getReferences()) {
                String referenceName = reference.getName().toString();
                Matcher referenceMatcher = referencePattern.matcher(referenceName);
                if (!referenceMatcher.find()) continue;
                System.out.println(PrintUtil.printReference(reference, 1));
            }
            System.out.println("]");
        }
        return null;
    }
}

