/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.switchyard.admin.Application;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;

@Command(scope="switchyard", name="reset-metrics", description="Reset metrics for the specified service/reference/application service.")
public class ResetMetricsCommand
extends AbstractSwitchYardServiceCommand {
    @Argument(index=0, name="type", description="Specifies the type [service | reference | application | all] of metrics to reset.", required=true)
    private SearchType _type;
    @Argument(index=1, name="patterns", description="Specifies the search pattern to use.", multiValued=true)
    private List<String> _patterns;
    @Option(name="--regex", description="If specified, treat the pattern(s) as a regular expression.")
    private boolean _regex;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        Pattern pattern = this.compilePattern(this._patterns, this._regex);
        this._type.resetMetrics(pattern, switchYard);
        return null;
    }

    public static enum SearchType {
        service{

            @Override
            public void resetMetrics(Pattern pattern, SwitchYard switchYard) {
                for (Service service : switchYard.getServices()) {
                    if (!pattern.matcher(service.getName().toString()).find()) continue;
                    service.resetMessageMetrics();
                }
            }
        }
        ,
        reference{

            @Override
            public void resetMetrics(Pattern pattern, SwitchYard switchYard) {
                for (Reference reference : switchYard.getReferences()) {
                    if (!pattern.matcher(reference.getName().toString()).find()) continue;
                    reference.resetMessageMetrics();
                }
            }
        }
        ,
        application{

            @Override
            public void resetMetrics(Pattern pattern, SwitchYard switchYard) {
                for (Application application : switchYard.getApplications()) {
                    if (!pattern.matcher(application.getName().toString()).find()) continue;
                    for (Service service : application.getServices()) {
                        service.resetMessageMetrics();
                    }
                    for (Reference reference : application.getReferences()) {
                        reference.resetMessageMetrics();
                    }
                    for (Service service : application.getComponentServices()) {
                        service.resetMessageMetrics();
                    }
                }
            }
        }
        ,
        all{

            @Override
            public void resetMetrics(Pattern pattern, SwitchYard switchYard) {
                switchYard.resetMessageMetrics();
            }
        };


        public abstract void resetMetrics(Pattern var1, SwitchYard var2);
    }
}

