/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;

public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);

    public JAXRSOutInterceptor() {
        super("marshal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance(message);
        try {
            this.processResponse(providerFactory, message);
        }
        finally {
            ServerProviderFactory.releaseRequestState(providerFactory, message);
        }
    }

    private void processResponse(ServerProviderFactory providerFactory, Message message) {
        if (this.isResponseAlreadyHandled(message)) {
            return;
        }
        MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        Object responseObj = objs.get(0);
        Response response = null;
        if (responseObj instanceof Response) {
            response = (Response)responseObj;
            if (response.getStatus() == 500 && message.getExchange().get((Object)"exception.from.mapper") != null) {
                message.put((Object)Message.RESPONSE_CODE, (Object)500);
                return;
            }
        } else {
            int status = this.getStatus(message, responseObj != null ? 200 : 204);
            response = Response.status((int)status).entity(responseObj).build();
        }
        Exchange exchange = message.getExchange();
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get((Object)OperationResourceInfo.class.getName());
        this.serializeMessage(providerFactory, message, response, ori, true);
    }

    private int getStatus(Message message, int defaultValue) {
        Object customStatus = message.getExchange().get((Object)Message.RESPONSE_CODE);
        return customStatus == null ? defaultValue : (Integer)customStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeMessage(ServerProviderFactory providerFactory, Message message, Response theResponse, OperationResourceInfo ori, boolean firstTry) {
        boolean ignoreWriters;
        ResponseImpl response = (ResponseImpl)JAXRSUtils.copyResponseIfNeeded(theResponse);
        Exchange exchange = message.getExchange();
        boolean headResponse = response.getStatus() == 200 && firstTry && ori != null && "HEAD".equals(ori.getHttpMethod());
        Object entity = response.getActualEntity();
        if (headResponse && entity != null) {
            LOG.info(new org.apache.cxf.common.i18n.Message("HEAD_WITHOUT_ENTITY", BUNDLE, new Object[0]).toString());
            entity = null;
        }
        Method invoked = ori == null ? null : (ori.getAnnotatedMethod() != null ? ori.getAnnotatedMethod() : ori.getMethodToInvoke());
        Annotation[] annotations = null;
        Annotation[] staticAnns = ori != null ? ori.getOutAnnotations() : new Annotation[]{};
        Annotation[] responseAnns = response.getEntityAnnotations();
        if (responseAnns != null) {
            annotations = new Annotation[staticAnns.length + responseAnns.length];
            System.arraycopy(staticAnns, 0, annotations, 0, staticAnns.length);
            System.arraycopy(responseAnns, 0, annotations, staticAnns.length, responseAnns.length);
        } else {
            annotations = staticAnns;
        }
        response.setStatus(this.getActualStatus(response.getStatus(), entity));
        response.setEntity(entity, annotations);
        MultivaluedMap<String, Object> responseHeaders = response.getMetadata();
        Map userHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (firstTry && userHeaders != null) {
            responseHeaders.putAll(userHeaders);
        }
        if (entity != null) {
            String initialResponseContentType = (String)message.get((Object)"Content-Type");
            if (initialResponseContentType != null && !responseHeaders.containsKey((Object)"Content-Type")) {
                responseHeaders.putSingle((Object)"Content-Type", (Object)initialResponseContentType);
            }
        } else {
            message.remove((Object)"Content-Type");
        }
        message.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
        this.setResponseDate(responseHeaders, firstTry);
        try {
            JAXRSUtils.runContainerResponseFilters(providerFactory, response, message, ori, invoked);
        }
        catch (Throwable ex) {
            this.handleWriteException(providerFactory, message, ex, firstTry);
            return;
        }
        entity = InjectionUtils.getEntity(response.getActualEntity());
        this.setResponseStatus(message, this.getActualStatus(response.getStatus(), entity));
        if (entity == null) {
            if (!headResponse) {
                responseHeaders.putSingle((Object)"Content-Length", (Object)"0");
                responseHeaders.remove((Object)"Content-Type");
                message.remove((Object)"Content-Type");
            }
            HttpUtils.convertHeaderValuesToString(responseHeaders, true);
            return;
        }
        Object ignoreWritersProp = exchange.get((Object)"ignore.message.writers");
        boolean bl = ignoreWriters = ignoreWritersProp == null ? false : Boolean.valueOf(ignoreWritersProp.toString());
        if (ignoreWriters) {
            this.writeResponseToStream((OutputStream)message.getContent(OutputStream.class), entity);
            return;
        }
        MediaType responseMediaType = this.getResponseMediaType(responseHeaders.getFirst((Object)"Content-Type"));
        Class<?> serviceCls = invoked != null ? ori.getClassResourceInfo().getServiceClass() : null;
        Class<?> targetType = InjectionUtils.getRawResponseClass(entity);
        Type genericType = InjectionUtils.getGenericResponseType(invoked, serviceCls, response.getActualEntity(), targetType, exchange);
        targetType = InjectionUtils.updateParamClassToTypeIfNeeded(targetType, genericType);
        annotations = response.getEntityAnnotations();
        List<WriterInterceptor> writers = providerFactory.createMessageBodyWriterInterceptor(targetType, genericType, annotations, responseMediaType, message, ori == null ? null : ori.getNameBindings());
        OutputStream outOriginal = (OutputStream)message.getContent(OutputStream.class);
        if (writers == null || writers.isEmpty()) {
            this.writeResponseErrorMessage(message, outOriginal, "NO_MSG_WRITER", targetType, responseMediaType);
            return;
        }
        responseMediaType = this.checkFinalContentType(responseMediaType, writers);
        String finalResponseContentType = JAXRSUtils.mediaTypeToString(responseMediaType, new String[0]);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Response content type is: " + finalResponseContentType);
        }
        responseHeaders.putSingle((Object)"Content-Type", (Object)finalResponseContentType);
        message.put((Object)"Content-Type", (Object)finalResponseContentType);
        boolean enabled = this.checkBufferingMode(message, writers, firstTry);
        try {
            try {
                JAXRSUtils.writeMessageBody(writers, entity, targetType, genericType, annotations, responseMediaType, responseHeaders, message);
                if (this.isResponseRedirected(message)) {
                    return;
                }
                this.checkCachedStream(message, outOriginal, enabled);
            }
            finally {
                if (enabled) {
                    message.setContent(OutputStream.class, (Object)outOriginal);
                    message.put((Object)XMLStreamWriter.class.getName(), null);
                }
            }
        }
        catch (Throwable ex) {
            this.logWriteError(firstTry, targetType, responseMediaType);
            this.handleWriteException(providerFactory, message, ex, firstTry);
        }
    }

    private MediaType getResponseMediaType(Object mediaTypeHeader) {
        MediaType responseMediaType = mediaTypeHeader instanceof MediaType ? (MediaType)mediaTypeHeader : (mediaTypeHeader == null ? MediaType.WILDCARD_TYPE : JAXRSUtils.toMediaType(mediaTypeHeader.toString()));
        return responseMediaType;
    }

    private int getActualStatus(int status, Object responseObj) {
        if (status == -1) {
            return responseObj == null ? 204 : 200;
        }
        return status;
    }

    private boolean checkBufferingMode(Message m, List<WriterInterceptor> writers, boolean firstTry) {
        if (!firstTry) {
            return false;
        }
        WriterInterceptor last = writers.get(writers.size() - 1);
        MessageBodyWriter<Object> w = ((WriterInterceptorMBW)last).getMBW();
        Object outBuf = m.getContextualProperty("org.apache.cxf.output.buffering");
        boolean enabled = MessageUtils.isTrue((Object)outBuf);
        boolean configurableProvider = w instanceof AbstractConfigurableProvider;
        if (!enabled && outBuf == null && configurableProvider) {
            enabled = ((AbstractConfigurableProvider)w).getEnableBuffering();
        }
        if (enabled) {
            boolean streamingOn;
            boolean bl = streamingOn = configurableProvider ? ((AbstractConfigurableProvider)w).getEnableStreaming() : false;
            if (streamingOn) {
                m.setContent(XMLStreamWriter.class, (Object)new CachingXmlEventWriter());
            } else {
                m.setContent(OutputStream.class, (Object)new CachedOutputStream());
            }
        }
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCachedStream(Message m, OutputStream osOriginal, boolean enabled) throws Exception {
        CachedOutputStream cos;
        OutputStream os;
        XMLStreamWriter writer = null;
        writer = enabled ? (XMLStreamWriter)m.getContent(XMLStreamWriter.class) : (XMLStreamWriter)m.get((Object)XMLStreamWriter.class.getName());
        if (writer instanceof CachingXmlEventWriter) {
            CachingXmlEventWriter cache = (CachingXmlEventWriter)writer;
            if (cache.getEvents().size() != 0) {
                XMLStreamWriter origWriter = null;
                try {
                    origWriter = StaxUtils.createXMLStreamWriter((OutputStream)osOriginal);
                    for (XMLEvent event : cache.getEvents()) {
                        StaxUtils.writeEvent((XMLEvent)event, (XMLStreamWriter)origWriter);
                    }
                }
                finally {
                    StaxUtils.close((XMLStreamWriter)origWriter);
                }
            }
            m.setContent(XMLStreamWriter.class, null);
            return;
        }
        if (enabled && (os = (OutputStream)m.getContent(OutputStream.class)) != osOriginal && os instanceof CachedOutputStream && (cos = (CachedOutputStream)os).size() != 0L) {
            cos.writeCacheTo(osOriginal);
        }
    }

    private void logWriteError(boolean firstTry, Class<?> cls, MediaType ct) {
        if (firstTry) {
            JAXRSUtils.logMessageHandlerProblem("MSG_WRITER_PROBLEM", cls, ct);
        }
    }

    private void handleWriteException(ServerProviderFactory pf, Message message, Throwable ex, boolean firstTry) {
        Response excResponse = null;
        if (firstTry) {
            excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
        }
        if (excResponse == null) {
            this.setResponseStatus(message, 500);
            throw new Fault(ex);
        }
        this.serializeMessage(pf, message, excResponse, null, false);
    }

    private void writeResponseErrorMessage(Message message, OutputStream out, String name, Class<?> cls, MediaType ct) {
        message.put((Object)"Content-Type", (Object)"text/plain");
        message.put((Object)Message.RESPONSE_CODE, (Object)500);
        try {
            String errorMessage = JAXRSUtils.logMessageHandlerProblem(name, cls, ct);
            if (out != null) {
                out.write(errorMessage.getBytes("UTF-8"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private MediaType checkFinalContentType(MediaType mt, List<WriterInterceptor> writers) {
        if (mt.isWildcardType() || mt.isWildcardSubtype()) {
            int mbwIndex = writers.size() == 1 ? 0 : writers.size() - 1;
            MessageBodyWriter<Object> writer = ((WriterInterceptorMBW)writers.get(mbwIndex)).getMBW();
            Produces pm = writer.getClass().getAnnotation(Produces.class);
            if (pm != null) {
                List<MediaType> sorted = JAXRSUtils.sortMediaTypes(JAXRSUtils.getMediaTypes(pm.value()), "qs");
                mt = JAXRSUtils.intersectMimeTypes(sorted, mt).get(0);
                if (mt.isWildcardType() || mt.isWildcardSubtype()) {
                    return MediaType.APPLICATION_OCTET_STREAM_TYPE;
                }
            } else {
                return MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
        }
        return mt;
    }

    private void setResponseDate(MultivaluedMap<String, Object> headers, boolean firstTry) {
        if (!firstTry || headers.containsKey((Object)"Date")) {
            return;
        }
        SimpleDateFormat format = HttpUtils.getHttpDateFormat();
        headers.putSingle((Object)"Date", (Object)format.format(new Date()));
    }

    private boolean isResponseAlreadyHandled(Message m) {
        return this.isResponseAlreadyCommited(m) || this.isResponseRedirected(m);
    }

    private boolean isResponseAlreadyCommited(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get((Object)"http.response.done"));
    }

    private boolean isResponseRedirected(Message outMessage) {
        return Boolean.TRUE.equals(outMessage.get((Object)"http.request.redirected"));
    }

    private void writeResponseToStream(OutputStream os, Object responseObj) {
        try {
            byte[] bytes = responseObj.toString().getBytes("UTF-8");
            os.write(bytes, 0, bytes.length);
        }
        catch (Exception ex) {
            LOG.severe("Problem with writing the data to the output stream");
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private void setResponseStatus(Message message, int status) {
        message.put((Object)Message.RESPONSE_CODE, (Object)status);
        boolean responseHeadersCopied = this.isResponseHeadersCopied(message);
        if (responseHeadersCopied) {
            HttpServletResponse response = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
            response.setStatus(status);
        }
    }

    private boolean isResponseHeadersCopied(Message message) {
        return MessageUtils.isTrue((Object)message.get((Object)"http.headers.copied"));
    }

    public void handleFault(Message message) {
    }
}

