/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Converter;
import org.eclipse.emf.ecore.EObject;
import org.fusesource.camel.component.sap.model.rfc.Response;
import org.fusesource.camel.component.sap.model.rfc.impl.ResponseImpl;
import org.fusesource.camel.component.sap.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public enum ResponseConverter {
    INSTANCE;

    private static final Logger LOG;

    @Converter
    public static Response toResponse(String string) {
        try {
            EObject eObject = Util.unmarshal(string);
            if (ResponseImpl.class.isInstance(eObject)) {
                return (ResponseImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert String to Response", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static Response toResponse(InputStream in) {
        try {
            EObject eObject = Util.fromInputStream(in);
            if (ResponseImpl.class.isInstance(eObject)) {
                return (ResponseImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert InputStream to Response", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static Response toResponse(byte[] byteArray) {
        try {
            EObject eObject = Util.unmarshal(new String(byteArray));
            if (ResponseImpl.class.isInstance(eObject)) {
                return (ResponseImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert byte array to Response", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static String toString(ResponseImpl structure) {
        try {
            return Util.marshal(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Response to String", (Throwable)e);
            return null;
        }
    }

    @Converter
    public static OutputStream toOutputStream(ResponseImpl structure) {
        try {
            return Util.toOutputStream(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Response to OutputStream", (Throwable)e);
            return null;
        }
    }

    @Converter
    public static InputStream toInputStream(ResponseImpl structure) {
        try {
            return Util.toInputStream(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Response to InputStream", (Throwable)e);
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ResponseConverter.class);
    }
}

