/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.util;

import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.fusesource.camel.component.sap.model.idoc.IdocPackage;
import org.fusesource.camel.component.sap.model.rfc.RfcPackage;
import org.xml.sax.InputSource;

public class Util {
    public static final EPackage.Registry registry = EPackage.Registry.INSTANCE;
    private static final SimpleDateFormat sapDateFormat = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat sapTimeFormat = new SimpleDateFormat("HHmmss");

    public static synchronized Date convertSapDateStringToDate(String sapDateString) {
        try {
            return sapDateFormat.parse(sapDateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static synchronized Date convertSapTimeStringToDate(String sapTimeString) {
        try {
            return sapTimeFormat.parse(sapTimeString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String marshal(EObject eObject) throws IOException {
        Util.ensureBasePackages();
        URI uri = URI.createFileURI("/");
        XMLResourceImpl resource = new XMLResourceImpl(uri);
        eObject = EcoreUtil.copy(eObject);
        resource.getContents().add(eObject);
        StringWriter out = new StringWriter();
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        ArrayList lookupTable = new ArrayList();
        options.put("CONFIGURATION_CACHE", Boolean.TRUE);
        options.put("USE_CACHED_LOOKUP_TABLE", lookupTable);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        resource.save(out, options);
        return out.toString();
    }

    public static EObject unmarshal(String string) throws IOException {
        Util.ensureBasePackages();
        URI uri = URI.createFileURI("/");
        XMLResourceImpl resource = new XMLResourceImpl(uri);
        StringReader in = new StringReader(string);
        HashMap<String, Object> options = new HashMap<String, Object>();
        XMLParserPoolImpl parserPool = new XMLParserPoolImpl();
        HashMap nameToFeatureMap = new HashMap();
        options.put("DEFER_ATTACHMENT", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        options.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        options.put("USE_PARSER_POOL", parserPool);
        options.put("USE_XML_NAME_TO_FEATURE_MAP", nameToFeatureMap);
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        resource.load(new InputSource(in), options);
        return (EObject)resource.getContents().get(0);
    }

    public static void save(File file, EObject eObject) throws IOException {
        Util.ensureBasePackages();
        URI uri = URI.createFileURI(file.getAbsolutePath());
        XMLResourceImpl res = new XMLResourceImpl(uri);
        eObject = EcoreUtil.copy(eObject);
        res.getContents().add(eObject);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        ArrayList lookupTable = new ArrayList();
        options.put("CONFIGURATION_CACHE", Boolean.TRUE);
        options.put("USE_CACHED_LOOKUP_TABLE", lookupTable);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        res.save(options);
    }

    public static EObject load(File file) throws IOException {
        Util.ensureBasePackages();
        URI uri = URI.createFileURI(file.getAbsolutePath());
        XMLResourceImpl res = new XMLResourceImpl(uri);
        HashMap<String, Object> options = new HashMap<String, Object>();
        XMLParserPoolImpl parserPool = new XMLParserPoolImpl();
        HashMap nameToFeatureMap = new HashMap();
        options.put("DEFER_ATTACHMENT", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        options.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        options.put("USE_PARSER_POOL", parserPool);
        options.put("USE_XML_NAME_TO_FEATURE_MAP", nameToFeatureMap);
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        res.load(options);
        return (EObject)res.getContents().get(0);
    }

    public static boolean setValue(EObject eObject, String featureName, Object value) {
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return false;
        }
        return Util.setValue(eObject, feature, value);
    }

    public static boolean setValue(EObject eObject, EStructuralFeature feature, Object value) {
        try {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(eObject);
            if (editingDomain == null) {
                eObject.eSet(feature, value);
            } else {
                Command setCommand = SetCommand.create(editingDomain, eObject, feature, value);
                editingDomain.getCommandStack().execute(setCommand);
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Object getValue(EObject eObject, EStructuralFeature feature) {
        try {
            Object value = eObject.eGet(feature);
            if (value == null && feature instanceof EReference) {
                EClass eClass = ((EReference)feature).getEReferenceType();
                value = eClass.getEPackage().getEFactoryInstance().create(eClass);
                Util.setValue(eObject, feature, value);
            }
            return value;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object getValue(EObject object, String featureName) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return null;
        }
        return Util.getValue(object, feature);
    }

    public static OutputStream toOutputStream(EObject eObject) throws IOException {
        Util.ensureBasePackages();
        XMLResourceImpl resource = new XMLResourceImpl();
        eObject = EcoreUtil.copy(eObject);
        resource.getContents().add(eObject);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        resource.save(out, null);
        return out;
    }

    public static void print(EObject eObject) throws IOException {
        Util.ensureBasePackages();
        XMLResourceImpl resource = new XMLResourceImpl();
        resource.getContents().add(eObject);
        resource.save(System.out, null);
    }

    public static InputStream toInputStream(EObject eObject) throws IOException {
        String string = Util.marshal(eObject);
        ByteArrayInputStream in = new ByteArrayInputStream(string.getBytes());
        return in;
    }

    public static EObject fromInputStream(InputStream in) throws IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        resource.load(in, null);
        return (EObject)resource.getContents().get(0);
    }

    public static void addAnnotation(EModelElement modelElement, String source, String key, String value) {
        EAnnotation annotation = modelElement.getEAnnotation(source);
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(source);
            annotation.setEModelElement(modelElement);
        }
        annotation.getDetails().put(key, value);
    }

    public static String getAnnotation(EModelElement modelElement, String source, String key) {
        EAnnotation annotation = modelElement.getEAnnotation(source);
        if (annotation == null) {
            return null;
        }
        return annotation.getDetails().get(key);
    }

    public static void beginTransaction(JCoDestination jcoDestination) {
        JCoContext.begin((JCoDestination)jcoDestination);
    }

    public static void commitTransaction(JCoDestination jcoDestination) throws JCoException {
        try {
            JCoRequest request = jcoDestination.getRepository().getRequest("BAPI_TRANSACTION_COMMIT");
            request.setValue("WAIT", "X");
            request.execute(jcoDestination);
        }
        finally {
            JCoContext.end((JCoDestination)jcoDestination);
        }
    }

    public static void rollbackTransaction(JCoDestination jcoDestination) throws JCoException {
        try {
            JCoRequest request = jcoDestination.getRepository().getRequest("BAPI_TRANSACTION_ROLLBACK");
            request.execute(jcoDestination);
        }
        finally {
            JCoContext.end((JCoDestination)jcoDestination);
        }
    }

    public static void saveRegistry(File file) throws IOException {
        Util.ensureBasePackages();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        URI fileURI = URI.createFileURI(file.getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        HashSet nsURIs = new HashSet();
        nsURIs.addAll(registry.keySet());
        for (String nsURI : nsURIs) {
            if (!nsURI.startsWith("http://sap.fusesource.org/idoc") && !nsURI.startsWith("http://sap.fusesource.org/rfc")) continue;
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            resource.getContents().add(ePackage);
        }
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        ArrayList lookupTable = new ArrayList();
        options.put("CONFIGURATION_CACHE", Boolean.TRUE);
        options.put("USE_CACHED_LOOKUP_TABLE", lookupTable);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        resource.save(options);
    }

    public static void loadRegistry(File file) throws IOException {
        Util.ensureBasePackages();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getPackageRegistry().put("http://sap.fusesource.org/idoc", IdocPackage.eINSTANCE);
        URI fileURI = URI.createFileURI(file.getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        XMLParserPoolImpl parserPool = new XMLParserPoolImpl();
        HashMap nameToFeatureMap = new HashMap();
        options.put("DEFER_ATTACHMENT", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        options.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        options.put("USE_PARSER_POOL", parserPool);
        options.put("USE_XML_NAME_TO_FEATURE_MAP", nameToFeatureMap);
        resource.load(null);
        ListIterator it = resource.getContents().listIterator();
        while (it.hasNext()) {
            EPackage ePackage;
            EObject eObj = (EObject)it.next();
            if (!(eObj instanceof EPackage) || "http://sap.fusesource.org/idoc".endsWith((ePackage = (EPackage)eObj).getNsURI()) || "http://sap.fusesource.org/rfc".endsWith(ePackage.getNsURI())) continue;
            Util.reattachStaticPackageSuperTypes(ePackage);
            registry.put(ePackage.getNsURI(), ePackage);
        }
    }

    public static void reattachStaticPackageSuperTypes(EPackage ePackage) {
        block95: {
            block93: {
                if (!ePackage.getNsURI().startsWith("http://sap.fusesource.org/idoc")) break block93;
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    if (!(eClassifier instanceof EClass)) continue;
                    EClass eClass = (EClass)eClassifier;
                    EList<EClass> superTypes = eClass.getESuperTypes();
                    int i = 0;
                    while (i < superTypes.size()) {
                        EClass superClass = (EClass)superTypes.get(i);
                        switch (superClass.getName()) {
                            case "Document": {
                                superTypes.set(i, IdocPackage.eINSTANCE.getDocument());
                                break;
                            }
                            case "Segment": {
                                superTypes.set(i, IdocPackage.eINSTANCE.getSegment());
                                break;
                            }
                            case "SegmentChildren": {
                                superTypes.set(i, IdocPackage.eINSTANCE.getSegmentChildren());
                                break;
                            }
                            case "SegmentList": {
                                superTypes.set(i, IdocPackage.eINSTANCE.getSegmentList());
                            }
                        }
                        ++i;
                    }
                }
                break block95;
            }
            if (!ePackage.getNsURI().startsWith("http://sap.fusesource.org/rfc")) break block95;
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                EList<EClass> superTypes = eClass.getESuperTypes();
                int i = 0;
                while (i < superTypes.size()) {
                    EClass superClass = (EClass)superTypes.get(i);
                    switch (superClass.getName()) {
                        case "AbapException": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getAbapException());
                            break;
                        }
                        case "Destination": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getDestination());
                            break;
                        }
                        case "DestinationData": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getDestinationData());
                            break;
                        }
                        case "DestinationDataEntry": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getDestinationDataEntry());
                            break;
                        }
                        case "DestinationDataStore": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getDestinationDataStore());
                            break;
                        }
                        case "DestinationDataStoreEntry": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getDestinationDataStoreEntry());
                            break;
                        }
                        case "FieldMetaData": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getFieldMetaData());
                            break;
                        }
                        case "FunctionTemplate": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getFunctionTemplate());
                            break;
                        }
                        case "ListFieldMetaData": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getListFieldMetaData());
                            break;
                        }
                        case "RecordMetaData": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getRecordMetaData());
                            break;
                        }
                        case "RepositoryData": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getRepositoryData());
                            break;
                        }
                        case "RepositoryDataStore": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getRepositoryDataStore());
                            break;
                        }
                        case "RepositoryDataEntry": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getRepositoryDataEntry());
                            break;
                        }
                        case "RepositoryDataStoreEntry": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getRepositoryDataStoreEntry());
                            break;
                        }
                        case "RFC": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getRFC());
                            break;
                        }
                        case "Server": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getServer());
                            break;
                        }
                        case "ServerData": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getServerData());
                            break;
                        }
                        case "ServerDataEntry": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getServerDataEntry());
                            break;
                        }
                        case "ServerDataStore": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getServerDataStore());
                            break;
                        }
                        case "Request": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getRequest());
                            break;
                        }
                        case "Response": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getResponse());
                            break;
                        }
                        case "Structure": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getStructure());
                            break;
                        }
                        case "Table": {
                            superTypes.set(i, RfcPackage.eINSTANCE.getTable());
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static synchronized void ensureBasePackages() {
    }
}

