/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.WriteSkewHelper;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public boolean localNodeIsOwner(Object var1);

    public boolean localNodeIsPrimaryOwner(Object var1);

    public Address getPrimaryOwner(Object var1);

    public void commitEntry(CacheEntry var1, EntryVersion var2, boolean var3, InvocationContext var4);

    public Collection<Address> getOwners(Collection<Object> var1);

    public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public static class DistributionLogic
    extends AbstractClusteringDependentLogic {
        private DistributionManager dm;
        private Configuration configuration;
        private RpcManager rpcManager;
        private StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic keySpecificLogic = new WriteSkewHelper.KeySpecificLogic(){

            @Override
            public boolean performCheckOnKey(Object key) {
                return DistributionLogic.this.localNodeIsOwner(key);
            }
        };

        @Inject
        public void init(DistributionManager dm, Configuration configuration, RpcManager rpcManager, StateTransferLock stateTransferLock) {
            this.dm = dm;
            this.configuration = configuration;
            this.rpcManager = rpcManager;
            this.stateTransferLock = stateTransferLock;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.dm.getLocality(key).isLocal();
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            Address address = this.rpcManager.getAddress();
            return this.dm.getPrimaryLocation(key).equals(address);
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            return this.dm.getPrimaryLocation(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck, InvocationContext ctx) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                boolean isForeignOwned;
                boolean doCommit = true;
                boolean bl = isForeignOwned = !skipOwnershipCheck && !this.localNodeIsOwner(entry.getKey());
                if (isForeignOwned && !entry.isRemoved()) {
                    if (this.configuration.clustering().l1().enabled()) {
                        if (entry.getLifespan() < 0L || entry.getLifespan() > this.configuration.clustering().l1().lifespan()) {
                            entry.setLifespan(this.configuration.clustering().l1().lifespan());
                        }
                    } else {
                        doCommit = false;
                    }
                }
                boolean created = false;
                boolean removed = false;
                boolean evicted = false;
                if (!isForeignOwned) {
                    created = entry.isCreated();
                    removed = entry.isRemoved();
                    evicted = entry.isEvicted();
                }
                if (doCommit) {
                    this.commitCacheEntry(entry, newVersion);
                } else {
                    entry.rollback();
                }
                if (!isForeignOwned) {
                    this.notifyCommitEntry(created, removed, evicted, entry, ctx);
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return this.dm.getAffectedNodes(keys);
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, versionGenerator, context, this.keySpecificLogic);
            CacheTransaction cacheTransaction = context.getCacheTransaction();
            EntryVersionsMap uvOld = cacheTransaction.getUpdatedEntryVersions();
            if (uvOld != null && !uvOld.isEmpty()) {
                uvOld.putAll(uv);
                uv = uvOld;
            }
            cacheTransaction.setUpdatedEntryVersions(uv);
            return uv.isEmpty() ? null : uv;
        }
    }

    public static class ReplicationLogic
    extends InvalidationLogic {
        private StateTransferLock stateTransferLock;

        @Inject
        public void init(StateTransferLock stateTransferLock) {
            this.stateTransferLock = stateTransferLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck, InvocationContext ctx) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                super.commitEntry(entry, newVersion, skipOwnershipCheck, ctx);
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }
    }

    public static class InvalidationLogic
    extends AbstractClusteringDependentLogic {
        private StateTransferManager stateTransferManager;
        private RpcManager rpcManager;
        private static final WriteSkewHelper.KeySpecificLogic keySpecificLogic = new WriteSkewHelper.KeySpecificLogic(){

            @Override
            public boolean performCheckOnKey(Object key) {
                return true;
            }
        };

        @Inject
        public void init(RpcManager rpcManager, StateTransferManager stateTransferManager) {
            this.rpcManager = rpcManager;
            this.stateTransferManager = stateTransferManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key);
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().locatePrimaryOwner(key).equals(this.rpcManager.getAddress());
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().locatePrimaryOwner(key);
        }

        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck, InvocationContext ctx) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean evicted = entry.isEvicted();
            this.commitCacheEntry(entry, newVersion);
            this.notifyCommitEntry(created, removed, evicted, entry, ctx);
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            if (this.stateTransferManager.getCacheTopology().getReadConsistentHash().getMembers().get(0).equals(this.rpcManager.getAddress())) {
                EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, versionGenerator, context, keySpecificLogic);
                context.getCacheTransaction().setUpdatedEntryVersions(uv);
                return uv;
            }
            if (prepareCommand.getModifications().length == 0) {
                context.getCacheTransaction().setUpdatedEntryVersions(new EntryVersionsMap());
            }
            return null;
        }
    }

    public static class LocalLogic
    extends AbstractClusteringDependentLogic {
        @Override
        public boolean localNodeIsOwner(Object key) {
            return true;
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return true;
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            throw new IllegalStateException("Cannot invoke this method for local caches");
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public Address getAddress() {
            return null;
        }

        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck, InvocationContext ctx) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean evicted = entry.isEvicted();
            entry.commit(this.dataContainer, newVersion);
            this.notifyCommitEntry(created, removed, evicted, entry, ctx);
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            throw new IllegalStateException("Cannot invoke this method for local caches");
        }
    }

    public static abstract class AbstractClusteringDependentLogic
    implements ClusteringDependentLogic {
        protected DataContainer dataContainer;
        protected CacheNotifier notifier;
        private ReentrantPerEntryLockContainer lockContainer;

        @Inject
        public void init(DataContainer dataContainer, CacheNotifier notifier, Configuration configuration) {
            this.dataContainer = dataContainer;
            this.notifier = notifier;
            this.lockContainer = this.createLockContainer(configuration);
        }

        protected void notifyCommitEntry(boolean created, boolean removed, boolean evicted, CacheEntry entry, InvocationContext ctx) {
            if (removed && evicted) {
                this.notifier.notifyCacheEntryEvicted(entry.getKey(), entry.getValue(), ctx);
            } else if (removed) {
                this.notifier.notifyCacheEntryRemoved(entry.getKey(), null, false, ctx);
            } else {
                this.notifier.notifyCacheEntryModified(entry.getKey(), entry.getValue(), false, ctx);
                if (created) {
                    this.notifier.notifyCacheEntryCreated(entry.getKey(), false, ctx);
                }
            }
        }

        private ReentrantPerEntryLockContainer createLockContainer(Configuration configuration) {
            return new ReentrantPerEntryLockContainer(configuration.locking().concurrencyLevel());
        }

        public final boolean lock(Object key, boolean noWaitTime) throws InterruptedException {
            if (this.lockContainer == null) {
                return true;
            }
            long timeout = noWaitTime ? 0L : 1L;
            return this.lockContainer.acquireLock(null, key, timeout, TimeUnit.DAYS) != null;
        }

        public final void unlock(Object key) {
            if (this.lockContainer != null) {
                this.lockContainer.releaseLock(null, key);
            }
        }

        protected final void commitCacheEntry(CacheEntry entry, EntryVersion version) {
            this.forceLock(entry.getKey());
            entry.commit(this.dataContainer, version);
            this.unlock(entry.getKey());
        }

        private void forceLock(Object key) {
            boolean interrupted = false;
            boolean locked = false;
            do {
                try {
                    locked = this.lock(key, false);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            } while (!locked);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

