/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class TestReceiver {
    private ConnectionFactory connectionFactory;
    private String receiveQueueName;
    private String requestMessageId;
    private String staticReplyQueue;
    private Throwable ex;
    private boolean forceMessageIdAsCorrelationId;

    public TestReceiver(ConnectionFactory connectionFactory, String receiveQueueName, boolean forceMessageIdAsCorrelationId) {
        this.connectionFactory = connectionFactory;
        this.receiveQueueName = receiveQueueName;
        this.forceMessageIdAsCorrelationId = forceMessageIdAsCorrelationId;
        assert (this.connectionFactory != null);
        assert (this.receiveQueueName != null);
    }

    public String getRequestMessageId() {
        return this.requestMessageId;
    }

    public void setStaticReplyQueue(String staticReplyQueue) {
        this.staticReplyQueue = staticReplyQueue;
    }

    private void drainQueue() {
        try (ResourceCloser closer = new ResourceCloser();){
            Connection connection = closer.register(this.connectionFactory.createConnection());
            connection.start();
            Session session = closer.register(connection.createSession(false, 1));
            MessageConsumer consumer = closer.register(session.createConsumer((Destination)session.createQueue(this.receiveQueueName)));
            Message message = null;
            while ((message = consumer.receive(100L)) != null) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAndRespond() {
        try (ResourceCloser closer = new ResourceCloser();){
            Destination replyDest;
            Connection connection = closer.register(this.connectionFactory.createConnection());
            connection.start();
            Session session = closer.register(connection.createSession(false, 1));
            MessageConsumer consumer = closer.register(session.createConsumer((Destination)session.createQueue(this.receiveQueueName)));
            Message inMessage = consumer.receive(10000L);
            if (inMessage == null) {
                throw new RuntimeException("No message received on destination " + this.receiveQueueName);
            }
            this.requestMessageId = inMessage.getJMSMessageID();
            TextMessage replyMessage = session.createTextMessage("Result");
            String correlationId = this.forceMessageIdAsCorrelationId || inMessage.getJMSCorrelationID() == null ? inMessage.getJMSMessageID() : inMessage.getJMSCorrelationID();
            replyMessage.setJMSCorrelationID(correlationId);
            Object object = replyDest = this.staticReplyQueue != null ? session.createQueue(this.staticReplyQueue) : inMessage.getJMSReplyTo();
            if (replyDest != null) {
                MessageProducer producer = closer.register(session.createProducer(replyDest));
                producer.send((Message)replyMessage);
            }
        }
    }

    public void runAsync() {
        this.drainQueue();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TestReceiver.this.receiveAndRespond();
            }
        });
    }

    public void close() {
        if (this.ex != null) {
            throw new RuntimeException("Error while receiving message or sending reply", this.ex);
        }
    }
}

