/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.SIU_S16_GENERAL_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SIU_S16_LOCATIONL_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SIU_S16_PERSONNEL_RESOURCE;
import ca.uhn.hl7v2.model.v23.group.SIU_S16_SERVICE;
import ca.uhn.hl7v2.model.v23.segment.RGS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIU_S16_RESOURCES
extends AbstractGroup {
    public SIU_S16_RESOURCES(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RGS.class, true, false, false);
            this.add(SIU_S16_SERVICE.class, false, true, false);
            this.add(SIU_S16_GENERAL_RESOURCE.class, false, true, false);
            this.add(SIU_S16_LOCATIONL_RESOURCE.class, false, true, false);
            this.add(SIU_S16_PERSONNEL_RESOURCE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SIU_S16_RESOURCES - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public RGS getRGS() {
        RGS retVal = this.getTyped("RGS", RGS.class);
        return retVal;
    }

    public SIU_S16_SERVICE getSERVICE() {
        SIU_S16_SERVICE retVal = this.getTyped("SERVICE", SIU_S16_SERVICE.class);
        return retVal;
    }

    public SIU_S16_SERVICE getSERVICE(int rep) {
        SIU_S16_SERVICE retVal = this.getTyped("SERVICE", rep, SIU_S16_SERVICE.class);
        return retVal;
    }

    public int getSERVICEReps() {
        return this.getReps("SERVICE");
    }

    public List<SIU_S16_SERVICE> getSERVICEAll() throws HL7Exception {
        return this.getAllAsList("SERVICE", SIU_S16_SERVICE.class);
    }

    public void insertSERVICE(SIU_S16_SERVICE structure, int rep) throws HL7Exception {
        super.insertRepetition("SERVICE", structure, rep);
    }

    public SIU_S16_SERVICE insertSERVICE(int rep) throws HL7Exception {
        return (SIU_S16_SERVICE)super.insertRepetition("SERVICE", rep);
    }

    public SIU_S16_SERVICE removeSERVICE(int rep) throws HL7Exception {
        return (SIU_S16_SERVICE)super.removeRepetition("SERVICE", rep);
    }

    public SIU_S16_GENERAL_RESOURCE getGENERAL_RESOURCE() {
        SIU_S16_GENERAL_RESOURCE retVal = this.getTyped("GENERAL_RESOURCE", SIU_S16_GENERAL_RESOURCE.class);
        return retVal;
    }

    public SIU_S16_GENERAL_RESOURCE getGENERAL_RESOURCE(int rep) {
        SIU_S16_GENERAL_RESOURCE retVal = this.getTyped("GENERAL_RESOURCE", rep, SIU_S16_GENERAL_RESOURCE.class);
        return retVal;
    }

    public int getGENERAL_RESOURCEReps() {
        return this.getReps("GENERAL_RESOURCE");
    }

    public List<SIU_S16_GENERAL_RESOURCE> getGENERAL_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("GENERAL_RESOURCE", SIU_S16_GENERAL_RESOURCE.class);
    }

    public void insertGENERAL_RESOURCE(SIU_S16_GENERAL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("GENERAL_RESOURCE", structure, rep);
    }

    public SIU_S16_GENERAL_RESOURCE insertGENERAL_RESOURCE(int rep) throws HL7Exception {
        return (SIU_S16_GENERAL_RESOURCE)super.insertRepetition("GENERAL_RESOURCE", rep);
    }

    public SIU_S16_GENERAL_RESOURCE removeGENERAL_RESOURCE(int rep) throws HL7Exception {
        return (SIU_S16_GENERAL_RESOURCE)super.removeRepetition("GENERAL_RESOURCE", rep);
    }

    public SIU_S16_LOCATIONL_RESOURCE getLOCATIONL_RESOURCE() {
        SIU_S16_LOCATIONL_RESOURCE retVal = this.getTyped("LOCATIONL_RESOURCE", SIU_S16_LOCATIONL_RESOURCE.class);
        return retVal;
    }

    public SIU_S16_LOCATIONL_RESOURCE getLOCATIONL_RESOURCE(int rep) {
        SIU_S16_LOCATIONL_RESOURCE retVal = this.getTyped("LOCATIONL_RESOURCE", rep, SIU_S16_LOCATIONL_RESOURCE.class);
        return retVal;
    }

    public int getLOCATIONL_RESOURCEReps() {
        return this.getReps("LOCATIONL_RESOURCE");
    }

    public List<SIU_S16_LOCATIONL_RESOURCE> getLOCATIONL_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("LOCATIONL_RESOURCE", SIU_S16_LOCATIONL_RESOURCE.class);
    }

    public void insertLOCATIONL_RESOURCE(SIU_S16_LOCATIONL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("LOCATIONL_RESOURCE", structure, rep);
    }

    public SIU_S16_LOCATIONL_RESOURCE insertLOCATIONL_RESOURCE(int rep) throws HL7Exception {
        return (SIU_S16_LOCATIONL_RESOURCE)super.insertRepetition("LOCATIONL_RESOURCE", rep);
    }

    public SIU_S16_LOCATIONL_RESOURCE removeLOCATIONL_RESOURCE(int rep) throws HL7Exception {
        return (SIU_S16_LOCATIONL_RESOURCE)super.removeRepetition("LOCATIONL_RESOURCE", rep);
    }

    public SIU_S16_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE() {
        SIU_S16_PERSONNEL_RESOURCE retVal = this.getTyped("PERSONNEL_RESOURCE", SIU_S16_PERSONNEL_RESOURCE.class);
        return retVal;
    }

    public SIU_S16_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE(int rep) {
        SIU_S16_PERSONNEL_RESOURCE retVal = this.getTyped("PERSONNEL_RESOURCE", rep, SIU_S16_PERSONNEL_RESOURCE.class);
        return retVal;
    }

    public int getPERSONNEL_RESOURCEReps() {
        return this.getReps("PERSONNEL_RESOURCE");
    }

    public List<SIU_S16_PERSONNEL_RESOURCE> getPERSONNEL_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("PERSONNEL_RESOURCE", SIU_S16_PERSONNEL_RESOURCE.class);
    }

    public void insertPERSONNEL_RESOURCE(SIU_S16_PERSONNEL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("PERSONNEL_RESOURCE", structure, rep);
    }

    public SIU_S16_PERSONNEL_RESOURCE insertPERSONNEL_RESOURCE(int rep) throws HL7Exception {
        return (SIU_S16_PERSONNEL_RESOURCE)super.insertRepetition("PERSONNEL_RESOURCE", rep);
    }

    public SIU_S16_PERSONNEL_RESOURCE removePERSONNEL_RESOURCE(int rep) throws HL7Exception {
        return (SIU_S16_PERSONNEL_RESOURCE)super.removeRepetition("PERSONNEL_RESOURCE", rep);
    }
}

