/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.CSU_C09_STUDY_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.CSU_C09_STUDY_PHARM;
import ca.uhn.hl7v2.model.v24.segment.CSS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSU_C09_STUDY_SCHEDULE
extends AbstractGroup {
    public CSU_C09_STUDY_SCHEDULE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CSS.class, false, false, false);
            this.add(CSU_C09_STUDY_OBSERVATION.class, true, true, false);
            this.add(CSU_C09_STUDY_PHARM.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSU_C09_STUDY_SCHEDULE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public CSS getCSS() {
        CSS retVal = this.getTyped("CSS", CSS.class);
        return retVal;
    }

    public CSU_C09_STUDY_OBSERVATION getSTUDY_OBSERVATION() {
        CSU_C09_STUDY_OBSERVATION retVal = this.getTyped("STUDY_OBSERVATION", CSU_C09_STUDY_OBSERVATION.class);
        return retVal;
    }

    public CSU_C09_STUDY_OBSERVATION getSTUDY_OBSERVATION(int rep) {
        CSU_C09_STUDY_OBSERVATION retVal = this.getTyped("STUDY_OBSERVATION", rep, CSU_C09_STUDY_OBSERVATION.class);
        return retVal;
    }

    public int getSTUDY_OBSERVATIONReps() {
        return this.getReps("STUDY_OBSERVATION");
    }

    public List<CSU_C09_STUDY_OBSERVATION> getSTUDY_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("STUDY_OBSERVATION", CSU_C09_STUDY_OBSERVATION.class);
    }

    public void insertSTUDY_OBSERVATION(CSU_C09_STUDY_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY_OBSERVATION", structure, rep);
    }

    public CSU_C09_STUDY_OBSERVATION insertSTUDY_OBSERVATION(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_OBSERVATION)super.insertRepetition("STUDY_OBSERVATION", rep);
    }

    public CSU_C09_STUDY_OBSERVATION removeSTUDY_OBSERVATION(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_OBSERVATION)super.removeRepetition("STUDY_OBSERVATION", rep);
    }

    public CSU_C09_STUDY_PHARM getSTUDY_PHARM() {
        CSU_C09_STUDY_PHARM retVal = this.getTyped("STUDY_PHARM", CSU_C09_STUDY_PHARM.class);
        return retVal;
    }

    public CSU_C09_STUDY_PHARM getSTUDY_PHARM(int rep) {
        CSU_C09_STUDY_PHARM retVal = this.getTyped("STUDY_PHARM", rep, CSU_C09_STUDY_PHARM.class);
        return retVal;
    }

    public int getSTUDY_PHARMReps() {
        return this.getReps("STUDY_PHARM");
    }

    public List<CSU_C09_STUDY_PHARM> getSTUDY_PHARMAll() throws HL7Exception {
        return this.getAllAsList("STUDY_PHARM", CSU_C09_STUDY_PHARM.class);
    }

    public void insertSTUDY_PHARM(CSU_C09_STUDY_PHARM structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY_PHARM", structure, rep);
    }

    public CSU_C09_STUDY_PHARM insertSTUDY_PHARM(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_PHARM)super.insertRepetition("STUDY_PHARM", rep);
    }

    public CSU_C09_STUDY_PHARM removeSTUDY_PHARM(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_PHARM)super.removeRepetition("STUDY_PHARM", rep);
    }
}

