/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.MFR_M01_MF_QUERY;
import ca.uhn.hl7v2.model.v24.segment.DSC;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MFI;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QAK;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.model.v24.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFR_M01
extends AbstractMessage {
    public MFR_M01() {
        this(new DefaultModelClassFactory());
    }

    public MFR_M01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, false, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFR_M01_MF_QUERY.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFR_M01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return this.getTyped("QRF", QRF.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFR_M01_MF_QUERY getMF_QUERY() {
        return this.getTyped("MF_QUERY", MFR_M01_MF_QUERY.class);
    }

    public MFR_M01_MF_QUERY getMF_QUERY(int rep) {
        return this.getTyped("MF_QUERY", rep, MFR_M01_MF_QUERY.class);
    }

    public int getMF_QUERYReps() {
        return this.getReps("MF_QUERY");
    }

    public List<MFR_M01_MF_QUERY> getMF_QUERYAll() throws HL7Exception {
        return this.getAllAsList("MF_QUERY", MFR_M01_MF_QUERY.class);
    }

    public void insertMF_QUERY(MFR_M01_MF_QUERY structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_QUERY", structure, rep);
    }

    public MFR_M01_MF_QUERY insertMF_QUERY(int rep) throws HL7Exception {
        return (MFR_M01_MF_QUERY)super.insertRepetition("MF_QUERY", rep);
    }

    public MFR_M01_MF_QUERY removeMF_QUERY(int rep) throws HL7Exception {
        return (MFR_M01_MF_QUERY)super.removeRepetition("MF_QUERY", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

