/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.ADT_A43_PATIENT;
import ca.uhn.hl7v2.model.v251.segment.EVN;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A43
extends AbstractMessage {
    public ADT_A43() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A43(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(ADT_A43_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A43 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public ADT_A43_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", ADT_A43_PATIENT.class);
    }

    public ADT_A43_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, ADT_A43_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<ADT_A43_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", ADT_A43_PATIENT.class);
    }

    public void insertPATIENT(ADT_A43_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public ADT_A43_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (ADT_A43_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public ADT_A43_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (ADT_A43_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

