/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.IS;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.PL;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.TX;
import ca.uhn.hl7v2.model.v251.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM7
extends AbstractSegment {
    public OM7(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Universal Service Identifier");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Category Identifier");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Category Description");
            this.add(ST.class, false, 0, 200, new Object[]{this.getMessage()}, "Category Synonym");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Test/Service Start Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Test/Service End Date/Time");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Test/Service Default Duration Quantity");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Test/Service Default Duration Units");
            this.add(IS.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(335)}, "Test/Service Default Frequency");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Consent Indicator");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Consent Identifier");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Consent Effective Start Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Consent Effective End Date/Time");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Consent Interval Quantity");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Consent Interval Units");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Consent Waiting Period Quantity");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Consent Waiting Period Units");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Date/Time of Change");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Entered By");
            this.add(PL.class, false, 0, 200, new Object[]{this.getMessage()}, "Orderable-at Location");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(473)}, "Formulary Status");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Special Order Indicator");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Primary Key Value - CDM");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM7 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm71_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getUniversalServiceIdentifier() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getOm72_UniversalServiceIdentifier() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE[] getCategoryIdentifier() {
        CE[] retVal = (CE[])this.getTypedField(3, new CE[0]);
        return retVal;
    }

    public CE[] getOm73_CategoryIdentifier() {
        CE[] retVal = (CE[])this.getTypedField(3, new CE[0]);
        return retVal;
    }

    public int getCategoryIdentifierReps() {
        return this.getReps(3);
    }

    public CE getCategoryIdentifier(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public CE getOm73_CategoryIdentifier(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm73_CategoryIdentifierReps() {
        return this.getReps(3);
    }

    public CE insertCategoryIdentifier(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE insertOm73_CategoryIdentifier(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE removeCategoryIdentifier(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE removeOm73_CategoryIdentifier(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public TX getCategoryDescription() {
        TX retVal = (TX)this.getTypedField(4, 0);
        return retVal;
    }

    public TX getOm74_CategoryDescription() {
        TX retVal = (TX)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getCategorySynonym() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getOm75_CategorySynonym() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getCategorySynonymReps() {
        return this.getReps(5);
    }

    public ST getCategorySynonym(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getOm75_CategorySynonym(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getOm75_CategorySynonymReps() {
        return this.getReps(5);
    }

    public ST insertCategorySynonym(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertOm75_CategorySynonym(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeCategorySynonym(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeOm75_CategorySynonym(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public TS getEffectiveTestServiceStartDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getOm76_EffectiveTestServiceStartDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getEffectiveTestServiceEndDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getOm77_EffectiveTestServiceEndDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getTestServiceDefaultDurationQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getOm78_TestServiceDefaultDurationQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getTestServiceDefaultDurationUnits() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getOm79_TestServiceDefaultDurationUnits() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getTestServiceDefaultFrequency() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getOm710_TestServiceDefaultFrequency() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getConsentIndicator() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getOm711_ConsentIndicator() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getConsentIdentifier() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getOm712_ConsentIdentifier() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getConsentEffectiveStartDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getOm713_ConsentEffectiveStartDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getConsentEffectiveEndDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getOm714_ConsentEffectiveEndDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getConsentIntervalQuantity() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getOm715_ConsentIntervalQuantity() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getConsentIntervalUnits() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getOm716_ConsentIntervalUnits() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getConsentWaitingPeriodQuantity() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getOm717_ConsentWaitingPeriodQuantity() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getConsentWaitingPeriodUnits() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getOm718_ConsentWaitingPeriodUnits() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public TS getEffectiveDateTimeOfChange() {
        TS retVal = (TS)this.getTypedField(19, 0);
        return retVal;
    }

    public TS getOm719_EffectiveDateTimeOfChange() {
        TS retVal = (TS)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN getEnteredBy() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getOm720_EnteredBy() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public PL[] getOrderableAtLocation() {
        PL[] retVal = (PL[])this.getTypedField(21, new PL[0]);
        return retVal;
    }

    public PL[] getOm721_OrderableAtLocation() {
        PL[] retVal = (PL[])this.getTypedField(21, new PL[0]);
        return retVal;
    }

    public int getOrderableAtLocationReps() {
        return this.getReps(21);
    }

    public PL getOrderableAtLocation(int rep) {
        PL retVal = (PL)this.getTypedField(21, rep);
        return retVal;
    }

    public PL getOm721_OrderableAtLocation(int rep) {
        PL retVal = (PL)this.getTypedField(21, rep);
        return retVal;
    }

    public int getOm721_OrderableAtLocationReps() {
        return this.getReps(21);
    }

    public PL insertOrderableAtLocation(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(21, rep);
    }

    public PL insertOm721_OrderableAtLocation(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(21, rep);
    }

    public PL removeOrderableAtLocation(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(21, rep);
    }

    public PL removeOm721_OrderableAtLocation(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(21, rep);
    }

    public IS getFormularyStatus() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public IS getOm722_FormularyStatus() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getSpecialOrderIndicator() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getOm723_SpecialOrderIndicator() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public CE[] getPrimaryKeyValueCDM() {
        CE[] retVal = (CE[])this.getTypedField(24, new CE[0]);
        return retVal;
    }

    public CE[] getOm724_PrimaryKeyValueCDM() {
        CE[] retVal = (CE[])this.getTypedField(24, new CE[0]);
        return retVal;
    }

    public int getPrimaryKeyValueCDMReps() {
        return this.getReps(24);
    }

    public CE getPrimaryKeyValueCDM(int rep) {
        CE retVal = (CE)this.getTypedField(24, rep);
        return retVal;
    }

    public CE getOm724_PrimaryKeyValueCDM(int rep) {
        CE retVal = (CE)this.getTypedField(24, rep);
        return retVal;
    }

    public int getOm724_PrimaryKeyValueCDMReps() {
        return this.getReps(24);
    }

    public CE insertPrimaryKeyValueCDM(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(24, rep);
    }

    public CE insertOm724_PrimaryKeyValueCDM(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(24, rep);
    }

    public CE removePrimaryKeyValueCDM(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(24, rep);
    }

    public CE removeOm724_PrimaryKeyValueCDM(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(24, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new TX(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(335));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new TS(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new TS(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new PL(this.getMessage());
            }
            case 21: {
                return new IS(this.getMessage(), new Integer(473));
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

