/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.util.Terser;

public class DeepCopy {
    public static void copy(Type from, Type to) throws DataTypeException {
        for (int i = 1; i <= Terser.numComponents(from); ++i) {
            for (int j = 1; j <= Terser.numSubComponents(from, i); ++j) {
                String val = Terser.getPrimitive(from, i, j).getValue();
                Terser.getPrimitive(to, i, j).setValue(val);
            }
        }
    }

    public static void copy(Segment from, Segment to) throws HL7Exception {
        int n = from.numFields();
        for (int i = 1; i <= n; ++i) {
            Type[] reps = from.getField(i);
            for (int j = 0; j < reps.length; ++j) {
                DeepCopy.copy(reps[j], to.getField(i, j));
            }
        }
    }
}

