/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.xml;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.milyn.util.ClassUtil;

public abstract class HTMLEntityLookup {
    private static Hashtable m_nameMap = new Hashtable();
    private static Hashtable m_codeMap = new Hashtable();

    private static void defineEntity(String entityName, char charCode) {
        if (m_nameMap.get(entityName) == null) {
            m_nameMap.put(entityName, new Character(charCode));
            m_codeMap.put(new Character(charCode), entityName);
        }
    }

    public static Character getCharacterCode(String entityName) {
        return (Character)m_nameMap.get(entityName);
    }

    public static String getEntityRef(char charCode) {
        return (String)m_codeMap.get(new Character(charCode));
    }

    static {
        InputStream is = null;
        BufferedReader reader = null;
        try {
            is = ClassUtil.getResourceAsStream("HTML.ent", HTMLEntityLookup.class);
            try {
                reader = new BufferedReader(new InputStreamReader(is));
            }
            catch (Exception except) {
                throw new IllegalStateException("Illegal State [" + except.getMessage() + "]: HTML.ent not in classpath or in wrong package.  Should be in package " + HTMLEntityLookup.class.getPackage().getName());
            }
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0 || line.charAt(0) == '#') {
                    line = reader.readLine();
                    continue;
                }
                int index = line.indexOf(32);
                if (index > 1) {
                    String name = line.substring(0, index);
                    if (++index < line.length()) {
                        String value = line.substring(index);
                        if ((index = value.indexOf(32)) > 0) {
                            value = value.substring(0, index);
                        }
                        int code = Integer.parseInt(value);
                        HTMLEntityLookup.defineEntity(name, (char)code);
                    }
                }
                line = reader.readLine();
            }
            is.close();
        }
        catch (Exception except) {
            except.printStackTrace();
            throw new IllegalStateException("Fatal ERROR: HTML.ent could not load: " + except.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

