/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.services;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NamingException;
import org.apache.aries.jndi.url.Activator;
import org.apache.aries.jndi.url.OsgiName;
import org.apache.aries.proxy.ProxyManager;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.util.nls.MessageUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public final class ServiceHelper {
    private static final ConcurrentMap<ServiceKey, WeakReference<Object>> proxyCache = new ConcurrentHashMap<ServiceKey, WeakReference<Object>>();
    private static final CacheClearoutListener cacheClearoutListener = new CacheClearoutListener(proxyCache);
    private static final MessageUtil MESSAGES = MessageUtil.createMessageUtil(ServiceHelper.class, (String)"org.apache.aries.jndi.nls.jndiUrlMessages");

    public static Object getService(BundleContext ctx, OsgiName lookupName, String id, boolean dynamicRebind, Map<String, Object> env, boolean requireProxy) throws NamingException {
        String interfaceName = lookupName.getInterface();
        String filter = lookupName.getFilter();
        String serviceName = lookupName.getServiceName();
        if (id != null) {
            filter = filter == null ? "(service.id=" + id + ')' : "(&(service.id=" + id + ')' + filter + ')';
        }
        ServicePair pair = null;
        if (!lookupName.isServiceNameBased()) {
            pair = ServiceHelper.findService(ctx, interfaceName, filter);
        }
        if (pair == null) {
            interfaceName = null;
            filter = id == null ? "(osgi.jndi.service.name=" + serviceName + ')' : "(&(service.id=" + id + ")(" + "osgi.jndi.service.name" + "=" + serviceName + "))";
            pair = ServiceHelper.findService(ctx, interfaceName, filter);
        }
        Object result = null;
        if (pair != null) {
            if (requireProxy) {
                Object obj = env.get("org.apache.aries.jndi.rebind.timeout");
                int timeout = 0;
                if (obj instanceof String) {
                    timeout = Integer.parseInt((String)obj);
                } else if (obj instanceof Integer) {
                    timeout = (Integer)obj;
                }
                result = ServiceHelper.proxy(interfaceName, filter, dynamicRebind, ctx, pair, timeout);
            } else {
                result = pair.service;
            }
        }
        return result;
    }

    private static Object proxy(final String interface1, final String filter, final boolean rebind, final BundleContext ctx, final ServicePair pair, final int timeout) {
        Object result = null;
        Bundle owningBundle = ctx.getBundle();
        ServiceKey k = new ServiceKey(owningBundle, pair.ref.getBundle(), (Long)pair.ref.getProperty("service.id"));
        WeakReference<Object> proxyRef = (WeakReference<Object>)proxyCache.get(k);
        if (proxyRef != null && (result = (Object)proxyRef.get()) == null) {
            proxyCache.remove(k, proxyRef);
        }
        if (result == null) {
            result = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return ServiceHelper.proxyPrivileged(interface1, filter, rebind, ctx, pair, timeout);
                }
            });
            proxyRef = new WeakReference<Object>(result);
            proxyCache.putIfAbsent(k, proxyRef);
            cacheClearoutListener.add(ctx, k);
        }
        return result;
    }

    private static Object proxyPrivileged(String interface1, String filter, boolean dynamicRebind, BundleContext ctx, ServicePair pair, int timeout) {
        String[] interfaces = null;
        interfaces = interface1 != null ? new String[]{interface1} : (String[])pair.ref.getProperty("objectClass");
        ArrayList clazz = new ArrayList(interfaces.length);
        Bundle serviceProviderBundle = pair.ref.getBundle();
        Bundle owningBundle = ctx.getBundle();
        ProxyManager proxyManager = Activator.getProxyManager();
        ArrayList<String> classesNotFound = new ArrayList<String>();
        for (String interfaceName : interfaces) {
            try {
                Class potentialClass = serviceProviderBundle.loadClass(interfaceName);
                if (!pair.ref.isAssignableTo(owningBundle, interfaceName)) continue;
                clazz.add(potentialClass);
            }
            catch (ClassNotFoundException e) {
                classesNotFound.add(interfaceName);
            }
        }
        if (clazz.isEmpty() && !classesNotFound.isEmpty()) {
            Class<?>[] ifacesOnService = ctx.getService(pair.ref).getClass().getInterfaces();
            for (String interfaceName : classesNotFound) {
                Class<?> thisClass = null;
                for (Class<?> c : ServiceHelper.getAllInterfaces(ifacesOnService)) {
                    if (!c.getName().equals(interfaceName)) continue;
                    thisClass = c;
                    break;
                }
                if (thisClass == null || !pair.ref.isAssignableTo(owningBundle, interfaceName)) continue;
                clazz.add(thisClass);
            }
        }
        if (clazz.isEmpty()) {
            throw new IllegalArgumentException(Arrays.asList(interfaces).toString());
        }
        JNDIServiceDamper ih = new JNDIServiceDamper(ctx, interface1, filter, pair, dynamicRebind, timeout);
        try {
            return proxyManager.createDelegatingProxy(serviceProviderBundle, clazz, (Callable)ih, null);
        }
        catch (UnableToProxyException e) {
            throw new IllegalArgumentException(e);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(MESSAGES.getMessage("unable.to.create.proxy", new Object[]{pair.ref}), e);
        }
    }

    private static ServicePair findService(BundleContext ctx, String interface1, String filter) throws NamingException {
        ServicePair p;
        block3: {
            p = null;
            try {
                ServiceReference[] refs = ctx.getServiceReferences(interface1, filter);
                if (refs == null) break block3;
                Arrays.sort(refs, new Comparator<ServiceReference>(){

                    @Override
                    public int compare(ServiceReference o1, ServiceReference o2) {
                        return o2.compareTo((Object)o1);
                    }
                });
                for (ServiceReference ref : refs) {
                    Object service = ctx.getService(ref);
                    if (service == null) continue;
                    p = new ServicePair();
                    p.ref = ref;
                    p.service = service;
                    break;
                }
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
        }
        return p;
    }

    public static ServiceReference[] getServiceReferences(BundleContext ctx, String interface1, String filter, String serviceName, Map<String, Object> env) throws NamingException {
        ServiceReference[] refs = null;
        try {
            refs = ctx.getServiceReferences(interface1, filter);
            if (refs == null || refs.length == 0) {
                refs = ctx.getServiceReferences((String)null, "(osgi.jndi.service.name=" + serviceName + ')');
            }
        }
        catch (InvalidSyntaxException e) {
            throw (NamingException)new NamingException(e.getFilter()).initCause(e);
        }
        if (refs != null) {
            Arrays.sort(refs, new Comparator<ServiceReference>(){

                @Override
                public int compare(ServiceReference o1, ServiceReference o2) {
                    return o2.compareTo((Object)o1);
                }
            });
        }
        return refs;
    }

    public static Object getService(BundleContext ctx, ServiceReference ref) {
        Object service = ctx.getService(ref);
        if (service == null) {
            return null;
        }
        ServicePair pair = new ServicePair();
        pair.ref = ref;
        pair.service = service;
        return ServiceHelper.proxy(null, null, false, ctx, pair, 0);
    }

    static Collection<Class<?>> getAllInterfaces(Class<?>[] baseInterfaces) {
        HashSet result = new HashSet();
        for (Class<?> c : baseInterfaces) {
            if (c.equals(Object.class)) continue;
            result.add(c);
            Class<?>[] ifaces = c.getInterfaces();
            if (ifaces.length == 0) continue;
            result.addAll(ServiceHelper.getAllInterfaces(ifaces));
        }
        return result;
    }

    private static class ServicePair {
        private ServiceReference ref;
        private Object service;

        private ServicePair() {
        }
    }

    private static class JNDIServiceDamper
    implements Callable<Object> {
        private BundleContext ctx;
        private ServicePair pair;
        private String interfaceName;
        private String filter;
        private boolean dynamic;
        private int rebindTimeout;

        public JNDIServiceDamper(BundleContext context, String i, String f, ServicePair service, boolean d, int timeout) {
            this.ctx = context;
            this.pair = service;
            this.interfaceName = i;
            this.filter = f;
            this.dynamic = d;
            this.rebindTimeout = timeout;
        }

        @Override
        public Object call() throws NamingException {
            if (this.pair == null || this.pair.ref.getBundle() == null) {
                if (this.dynamic) {
                    this.pair = ServiceHelper.findService(this.ctx, this.interfaceName, this.filter);
                    if (this.pair == null && this.rebindTimeout > 0) {
                        long startTime = System.currentTimeMillis();
                        try {
                            while (this.pair == null && System.currentTimeMillis() - startTime < (long)this.rebindTimeout) {
                                Thread.sleep(100L);
                                this.pair = ServiceHelper.findService(this.ctx, this.interfaceName, this.filter);
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    this.pair = null;
                }
            }
            if (this.pair == null) {
                throw new ServiceException(this.interfaceName, 1);
            }
            return this.pair.service;
        }
    }

    private static final class ServiceKey {
        private final Bundle requesting;
        private final Bundle registering;
        private final Long serviceId;
        private final int hash;

        public ServiceKey(Bundle owningBundle, Bundle registeringBundle, Long property) {
            this.requesting = owningBundle;
            this.registering = registeringBundle;
            this.serviceId = property;
            this.hash = this.serviceId.intValue() * 100003 + System.identityHashCode(this.requesting);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other instanceof ServiceKey) {
                ServiceKey otherKey = (ServiceKey)other;
                return otherKey.requesting == this.requesting && otherKey.serviceId.equals(this.serviceId);
            }
            return false;
        }
    }

    public static final class CacheClearoutListener
    implements BundleListener,
    ServiceListener {
        private final ConcurrentMap<ServiceKey, WeakReference<Object>> cache;

        public CacheClearoutListener(ConcurrentMap<ServiceKey, WeakReference<Object>> pc) {
            this.cache = pc;
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 4) {
                Bundle b = event.getBundle();
                Iterator keys = this.cache.keySet().iterator();
                while (keys.hasNext()) {
                    ServiceKey key = (ServiceKey)keys.next();
                    if (key.requesting != b) continue;
                    keys.remove();
                }
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 4) {
                ServiceReference ref = event.getServiceReference();
                Long serviceId = (Long)ref.getProperty("service.id");
                Bundle registeringBundle = ref.getBundle();
                Iterator keys = this.cache.keySet().iterator();
                while (keys.hasNext()) {
                    ServiceKey key = (ServiceKey)keys.next();
                    if (key.registering != registeringBundle || !serviceId.equals(key.serviceId)) continue;
                    keys.remove();
                    break;
                }
            }
        }

        public void add(final BundleContext ctx, ServiceKey k) {
            BundleContext systemBundle = AccessController.doPrivileged(new PrivilegedAction<BundleContext>(){

                @Override
                public BundleContext run() {
                    Bundle system = ctx.getBundle(0L);
                    return system == null ? null : system.getBundleContext();
                }
            });
            if (systemBundle == null) {
                systemBundle = ctx;
            }
            systemBundle.addBundleListener((BundleListener)cacheClearoutListener);
            systemBundle.addServiceListener((ServiceListener)cacheClearoutListener);
        }
    }
}

