/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.client;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.util.TypeLiteral;
import org.ops4j.pax.cdi.extension.impl.client.OsgiServiceIterator;
import org.ops4j.pax.cdi.spi.util.Exceptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiServiceInstance<T>
implements Instance<T> {
    private BundleContext bc;
    private Class<T> klass;
    private String filter;

    public OsgiServiceInstance(BundleContext bc, Class<T> klass, String filter) {
        this.bc = bc;
        this.klass = klass;
        this.filter = filter.isEmpty() ? null : filter;
    }

    public Iterator<T> iterator() {
        return new OsgiServiceIterator<T>(this.bc, this.getServiceReferences());
    }

    public T get() {
        if (this.isUnsatisfied()) {
            throw new UnsatisfiedResolutionException();
        }
        if (this.isAmbiguous()) {
            throw new AmbiguousResolutionException();
        }
        return this.iterator().next();
    }

    public Instance<T> select(Annotation ... qualifiers) {
        throw new UnsupportedOperationException();
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        throw new UnsupportedOperationException();
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        throw new UnsupportedOperationException();
    }

    public boolean isUnsatisfied() {
        Collection<ServiceReference<T>> refs = this.getServiceReferences();
        return refs.isEmpty();
    }

    private Collection<ServiceReference<T>> getServiceReferences() {
        try {
            Collection refs = this.bc.getServiceReferences(this.klass, this.filter);
            return refs;
        }
        catch (InvalidSyntaxException exc) {
            throw Exceptions.unchecked((Exception)((Object)exc));
        }
    }

    public boolean isAmbiguous() {
        return this.getServiceReferences().size() > 1;
    }
}

