/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.component;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.ops4j.pax.cdi.extension.impl.component.ComponentDependency;
import org.ops4j.pax.cdi.extension.impl.component.ComponentDependencyListener;
import org.ops4j.pax.cdi.extension.impl.util.InjectionPointOsgiUtils;
import org.ops4j.pax.cdi.spi.util.Exceptions;
import org.ops4j.pax.swissbox.lifecycle.AbstractLifecycle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class ComponentDescriptor<S>
extends AbstractLifecycle {
    private List<ComponentDependency<S, ?>> dependencies = new ArrayList();
    private int numUnsatisfiedDependencies;
    private ServiceRegistration<S> serviceRegistration;
    private ComponentDependencyListener listener;
    private Bean<S> bean;

    public ComponentDescriptor(Bean<S> bean) {
        this.bean = bean;
    }

    public boolean isSatisfied() {
        return this.numUnsatisfiedDependencies == 0;
    }

    public <T> void addDependency(InjectionPoint ip) {
        String filterString = InjectionPointOsgiUtils.getFilter(ip);
        try {
            Filter filter = FrameworkUtil.createFilter((String)filterString);
            ComponentDependency componentDependency = new ComponentDependency(this, ip, filter);
            this.dependencies.add(componentDependency);
            ++this.numUnsatisfiedDependencies;
        }
        catch (InvalidSyntaxException exc) {
            throw Exceptions.unchecked((Exception)((Object)exc));
        }
    }

    public void onDependencySatisfied() {
        --this.numUnsatisfiedDependencies;
        if (this.isSatisfied()) {
            this.listener.onComponentSatisfied(this);
        }
    }

    public void onDependencyUnsatisfied() {
        boolean notifyListener = this.isSatisfied();
        ++this.numUnsatisfiedDependencies;
        if (notifyListener && !this.isSatisfied()) {
            this.listener.onComponentUnsatisfied(this);
        }
    }

    public ServiceRegistration<S> getServiceRegistration() {
        return this.serviceRegistration;
    }

    public void setServiceRegistration(ServiceRegistration<S> serviceRegistration) {
        this.serviceRegistration = serviceRegistration;
    }

    public ComponentDependencyListener getListener() {
        return this.listener;
    }

    public void setListener(ComponentDependencyListener listener) {
        this.listener = listener;
    }

    public Bean<S> getBean() {
        return this.bean;
    }

    protected void onStart() {
        for (ComponentDependency<S, ?> dependency : this.dependencies) {
            dependency.start();
        }
    }

    protected void onStop() {
        this.listener.onComponentUnsatisfied(this);
        for (ComponentDependency<S, ?> dependency : this.dependencies) {
            dependency.stop();
        }
    }
}

