/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.serial.CompressionType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.WrapperSerializer;

public final class ZIPSerializer
extends WrapperSerializer {
    public ZIPSerializer(Serializer serializer) {
        super(serializer, CompressionType.ZIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out) throws IOException {
        out = new CountingOutputStream(out);
        ZipOutputStream zip = new ZipOutputStream(out);
        try {
            zip.putNextEntry(new ZipEntry("z"));
            this.getWrapped().serialize(obj, type, zip);
            zip.closeEntry();
            zip.finish();
            zip.flush();
        }
        finally {
            if (this.isCloseEnabled()) {
                zip.close();
            }
        }
        return ((CountingOutputStream)out).getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(InputStream in, Class<T> type) throws IOException {
        ZipInputStream zip = new ZipInputStream(in);
        try {
            zip.getNextEntry();
            T t = this.getWrapped().deserialize(zip, type);
            return t;
        }
        finally {
            if (this.isCloseEnabled()) {
                zip.close();
            }
        }
    }
}

