/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util.osgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.Service;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.util.FactoryFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
SynchronousBundleListener,
FactoryFinder.ObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private final ConcurrentMap<String, Class> serviceCache = new ConcurrentHashMap<String, Class>();
    private final ConcurrentMap<Long, BundleWrapper> bundleWrappers = new ConcurrentHashMap<Long, BundleWrapper>();
    private BundleContext bundleContext;

    public synchronized void start(BundleContext bundleContext) throws Exception {
        FactoryFinder.setObjectFactory(this);
        this.debug("activating");
        this.bundleContext = bundleContext;
        this.debug("checking existing bundles");
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.register(bundle);
        }
        this.debug("activated");
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        this.debug("deactivating");
        bundleContext.removeBundleListener((BundleListener)this);
        while (!this.bundleWrappers.isEmpty()) {
            this.unregister((Long)this.bundleWrappers.keySet().iterator().next());
        }
        this.debug("deactivated");
        this.bundleContext = null;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    protected void register(Bundle bundle) {
        this.debug("checking bundle " + bundle.getBundleId());
        if (!this.isImportingUs(bundle)) {
            this.debug("The bundle does not import us: " + bundle.getBundleId());
            return;
        }
        this.bundleWrappers.put(bundle.getBundleId(), new BundleWrapper(bundle));
    }

    protected void unregister(long bundleId) {
        BundleWrapper bundle = (BundleWrapper)this.bundleWrappers.remove(bundleId);
        if (bundle != null) {
            for (String path : bundle.cachedServices) {
                this.debug("unregistering service for key: " + path);
                this.serviceCache.remove(path);
            }
        }
    }

    @Override
    public Object create(String path) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class clazz = (Class)this.serviceCache.get(path);
        if (clazz == null) {
            StringBuffer warnings = new StringBuffer();
            int wrrningCounter = 1;
            for (BundleWrapper wrapper : this.bundleWrappers.values()) {
                URL resource = wrapper.bundle.getResource(path);
                if (resource == null) continue;
                Properties properties = this.loadProperties(resource);
                String className = properties.getProperty("class");
                if (className == null) {
                    warnings.append("(" + wrrningCounter++ + ") Invalid service file in bundle " + wrapper + ": 'class' property not defined.");
                    continue;
                }
                try {
                    clazz = wrapper.bundle.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    warnings.append("(" + wrrningCounter++ + ") Bundle " + wrapper + " could not load " + className + ": " + e);
                    continue;
                }
                this.serviceCache.put(path, clazz);
                wrapper.cachedServices.add(path);
                break;
            }
            if (clazz == null) {
                String msg = "Service not found: '" + path + "'";
                if (warnings.length() != 0) {
                    msg = msg + ", " + warnings;
                }
                throw new IOException(msg);
            }
        }
        return clazz.newInstance();
    }

    private void debug(Object msg) {
        LOG.debug(msg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL resource) throws IOException {
        InputStream in = resource.openStream();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean isImportingUs(Bundle bundle) {
        return this.isImportingClass(bundle, Service.class) || this.isImportingClass(bundle, Transport.class) || this.isImportingClass(bundle, DiscoveryAgent.class) || this.isImportingClass(bundle, PersistenceAdapter.class);
    }

    private boolean isImportingClass(Bundle bundle, Class clazz) {
        try {
            return bundle.loadClass(clazz.getName()) == clazz;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class BundleWrapper {
        private final Bundle bundle;
        private final List<String> cachedServices = new ArrayList<String>();

        public BundleWrapper(Bundle bundle) {
            this.bundle = bundle;
        }
    }
}

