/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.MultiKeyPasswordKeyManager;
import org.apache.cxf.configuration.jsse.SSLUtils;
import org.apache.cxf.configuration.security.CertStoreType;
import org.apache.cxf.configuration.security.KeyManagersType;
import org.apache.cxf.configuration.security.KeyStoreType;
import org.apache.cxf.configuration.security.SecureRandomParameters;
import org.apache.cxf.configuration.security.TrustManagersType;
import org.apache.cxf.resource.ResourceManager;

public final class TLSParameterJaxBUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(TLSParameterJaxBUtils.class);

    private TLSParameterJaxBUtils() {
    }

    public static SecureRandom getSecureRandom(SecureRandomParameters secureRandomParams) throws GeneralSecurityException {
        SecureRandom secureRandom = null;
        if (secureRandomParams != null) {
            String secureRandomAlg = secureRandomParams.getAlgorithm();
            String randomProvider = secureRandomParams.getProvider();
            secureRandom = randomProvider != null ? (secureRandomAlg != null ? SecureRandom.getInstance(secureRandomAlg, randomProvider) : null) : (secureRandomAlg != null ? SecureRandom.getInstance(secureRandomAlg) : null);
        }
        return secureRandom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(KeyStoreType kst) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        String tmp;
        char[] password;
        if (kst == null) {
            return null;
        }
        String type = SSLUtils.getKeystoreType(kst.isSetType() ? kst.getType() : null, LOG, KeyStore.getDefaultType());
        char[] cArray = password = kst.isSetPassword() ? TLSParameterJaxBUtils.deobfuscate(kst.getPassword()) : null;
        if (password == null && (tmp = SSLUtils.getKeystorePassword(null, LOG)) != null) {
            password = tmp.toCharArray();
        }
        String provider = SSLUtils.getKeystoreProvider(kst.isSetProvider() ? kst.getProvider() : null, LOG);
        KeyStore keyStore2 = keyStore = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
        if (kst.isSetFile()) {
            try (FileInputStream kstInputStream = null;){
                kstInputStream = new FileInputStream(kst.getFile());
                keyStore.load(kstInputStream, password);
            }
        }
        if (kst.isSetResource()) {
            InputStream is = TLSParameterJaxBUtils.getResourceAsStream(kst.getResource());
            if (is == null) {
                String msg = "Could not load keystore resource " + kst.getResource();
                LOG.severe(msg);
                throw new IOException(msg);
            }
            keyStore.load(is, password);
        } else if (kst.isSetUrl()) {
            keyStore.load(new URL(kst.getUrl()).openStream(), password);
        } else {
            String loc = SSLUtils.getKeystore(null, LOG);
            try (InputStream ins = null;){
                if (loc != null) {
                    ins = new FileInputStream(loc);
                }
                keyStore.load(ins, password);
            }
        }
        return keyStore;
    }

    public static KeyStore getKeyStore(CertStoreType pst) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (pst == null) {
            return null;
        }
        if (pst.isSetFile()) {
            return TLSParameterJaxBUtils.createTrustStore(new FileInputStream(pst.getFile()));
        }
        if (pst.isSetResource()) {
            InputStream is = TLSParameterJaxBUtils.getResourceAsStream(pst.getResource());
            if (is == null) {
                String msg = "Could not load truststore resource " + pst.getResource();
                LOG.severe(msg);
                throw new IOException(msg);
            }
            return TLSParameterJaxBUtils.createTrustStore(is);
        }
        if (pst.isSetUrl()) {
            return TLSParameterJaxBUtils.createTrustStore(new URL(pst.getUrl()).openStream());
        }
        return null;
    }

    private static InputStream getResourceAsStream(String resource) {
        Bus bus;
        ResourceManager rm;
        InputStream is = ClassLoaderUtils.getResourceAsStream(resource, TLSParameterJaxBUtils.class);
        if (is == null && (rm = (bus = BusFactory.getThreadDefaultBus(true)).getExtension(ResourceManager.class)) != null) {
            is = rm.getResourceAsStream(resource);
        }
        return is;
    }

    private static KeyStore createTrustStore(InputStream is) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Collection<? extends Certificate> certs = TLSParameterJaxBUtils.loadCertificates(is);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        for (Certificate certificate : certs) {
            X509Certificate xcert = (X509Certificate)certificate;
            keyStore.setCertificateEntry(xcert.getSubjectX500Principal().getName(), certificate);
        }
        return keyStore;
    }

    private static Collection<? extends Certificate> loadCertificates(InputStream is) throws IOException, CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertificates(is);
    }

    private static char[] deobfuscate(String s) {
        if (!s.startsWith("OBF:")) {
            return s.toCharArray();
        }
        s = s.substring(4);
        char[] b = new char[s.length() / 2];
        int l = 0;
        for (int i = 0; i < s.length(); i += 4) {
            String x = s.substring(i, i + 4);
            int i0 = Integer.parseInt(x, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            b[l++] = (char)((i1 + i2 - 254) / 2);
        }
        return new String(b, 0, l).toCharArray();
    }

    public static KeyManager[] getKeyManagers(KeyManagersType kmc) throws GeneralSecurityException, IOException {
        KeyStore keyStore = TLSParameterJaxBUtils.getKeyStore(kmc.getKeyStore());
        String alg = kmc.isSetFactoryAlgorithm() ? kmc.getFactoryAlgorithm() : KeyManagerFactory.getDefaultAlgorithm();
        char[] keyPass = kmc.isSetKeyPassword() ? TLSParameterJaxBUtils.deobfuscate(kmc.getKeyPassword()) : null;
        KeyManagerFactory fac = kmc.isSetProvider() ? KeyManagerFactory.getInstance(alg, kmc.getProvider()) : KeyManagerFactory.getInstance(alg);
        fac.init(keyStore, keyPass);
        return fac.getKeyManagers();
    }

    public static KeyManager[] getKeyManagers(KeyManagersType kmc, String alias) throws GeneralSecurityException, IOException {
        KeyStore keyStore = TLSParameterJaxBUtils.getKeyStore(kmc.getKeyStore());
        String alg = kmc.isSetFactoryAlgorithm() ? kmc.getFactoryAlgorithm() : KeyManagerFactory.getDefaultAlgorithm();
        char[] keyPass = kmc.isSetKeyPassword() ? TLSParameterJaxBUtils.deobfuscate(kmc.getKeyPassword()) : null;
        KeyManagerFactory fac = kmc.isSetProvider() ? KeyManagerFactory.getInstance(alg, kmc.getProvider()) : KeyManagerFactory.getInstance(alg);
        try {
            fac.init(keyStore, keyPass);
            return fac.getKeyManagers();
        }
        catch (UnrecoverableKeyException uke) {
            MultiKeyPasswordKeyManager manager = new MultiKeyPasswordKeyManager(keyStore, alias, new String(keyPass));
            return new KeyManager[]{manager};
        }
    }

    public static TrustManager[] getTrustManagers(TrustManagersType tmc) throws GeneralSecurityException, IOException {
        KeyStore keyStore = tmc.isSetKeyStore() ? TLSParameterJaxBUtils.getKeyStore(tmc.getKeyStore()) : (tmc.isSetCertStore() ? TLSParameterJaxBUtils.getKeyStore(tmc.getCertStore()) : (KeyStore)null);
        String alg = tmc.isSetFactoryAlgorithm() ? tmc.getFactoryAlgorithm() : TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory fac = tmc.isSetProvider() ? TrustManagerFactory.getInstance(alg, tmc.getProvider()) : TrustManagerFactory.getInstance(alg);
        fac.init(keyStore);
        return fac.getTrustManagers();
    }
}

