/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.TestTableOkBody;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class TestTableOkBodyImpl
extends AMQMethodBody_8_0
implements TestTableOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new TestTableOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 31;
    private final long _integerResult;
    private final byte[] _stringResult;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public TestTableOkBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._integerResult = this.readLong(buffer);
        this._stringResult = this.readBytes(buffer);
    }

    public TestTableOkBodyImpl(long integerResult, byte[] stringResult) {
        this._integerResult = integerResult;
        this._stringResult = stringResult;
    }

    @Override
    public int getClazz() {
        return 120;
    }

    @Override
    public int getMethod() {
        return 31;
    }

    @Override
    public final long getIntegerResult() {
        return this._integerResult;
    }

    @Override
    public final byte[] getStringResult() {
        return this._stringResult;
    }

    @Override
    protected int getBodySize() {
        int size = 8;
        return size += this.getSizeOf(this._stringResult);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeLong(buffer, this._integerResult);
        this.writeBytes(buffer, this._stringResult);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchTestTableOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[TestTableOkBodyImpl: ");
        buf.append("integerResult=");
        buf.append(this.getIntegerResult());
        buf.append(", ");
        buf.append("stringResult=");
        buf.append(this.getStringResult() == null ? "null" : Arrays.toString(this.getStringResult()));
        buf.append("]");
        return buf.toString();
    }
}

