/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.ProtocolError;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.transport.network.Frame;
import org.apache.qpid.transport.network.NetworkDelegate;
import org.apache.qpid.transport.network.NetworkEvent;

public class Assembler
implements Receiver<NetworkEvent>,
NetworkDelegate {
    private static final int ARRAY_SIZE = 255;
    private final Method[] _incompleteMethodArray = new Method[256];
    private final Map<Integer, Method> _incompleteMethodMap = new HashMap<Integer, Method>();
    private final Receiver<ProtocolEvent> receiver;
    private final Map<Integer, List<Frame>> segments;
    private static final ThreadLocal<BBDecoder> _decoder = new ThreadLocal<BBDecoder>(){

        @Override
        public BBDecoder initialValue() {
            return new BBDecoder();
        }
    };

    public Assembler(Receiver<ProtocolEvent> receiver) {
        this.receiver = receiver;
        this.segments = new HashMap<Integer, List<Frame>>();
    }

    private int segmentKey(Frame frame) {
        return (frame.getTrack() + 1) * frame.getChannel();
    }

    private List<Frame> getSegment(Frame frame) {
        return this.segments.get(this.segmentKey(frame));
    }

    private void setSegment(Frame frame, List<Frame> segment) {
        int key = this.segmentKey(frame);
        if (this.segments.containsKey(key)) {
            this.error(new ProtocolError(1, "segment in progress: %s", frame));
        }
        this.segments.put(this.segmentKey(frame), segment);
    }

    private void clearSegment(Frame frame) {
        this.segments.remove(this.segmentKey(frame));
    }

    private void emit(int channel, ProtocolEvent event) {
        event.setChannel(channel);
        this.receiver.received(event);
    }

    @Override
    public void received(NetworkEvent event) {
        event.delegate(this);
    }

    @Override
    public void exception(Throwable t) {
        this.receiver.exception(t);
    }

    @Override
    public void closed() {
        this.receiver.closed();
    }

    @Override
    public void init(ProtocolHeader header) {
        this.emit(0, header);
    }

    @Override
    public void error(ProtocolError error) {
        this.emit(0, error);
    }

    @Override
    public void frame(Frame frame) {
        if (frame.isFirstFrame() && frame.isLastFrame()) {
            ByteBuffer segment = frame.getBody();
            this.assemble(frame, segment);
        } else {
            List<Object> frames;
            if (frame.isFirstFrame()) {
                frames = new ArrayList();
                this.setSegment(frame, frames);
            } else {
                frames = this.getSegment(frame);
            }
            frames.add(frame);
            if (frame.isLastFrame()) {
                this.clearSegment(frame);
                int size = 0;
                for (Frame frame2 : frames) {
                    size += frame2.getSize();
                }
                ByteBuffer segment = ByteBuffer.allocate(size);
                for (Frame frame3 : frames) {
                    segment.put(frame3.getBody());
                }
                segment.flip();
                this.assemble(frame, segment);
            }
        }
    }

    private void assemble(Frame frame, ByteBuffer segment) {
        BBDecoder dec = _decoder.get();
        dec.init(segment);
        int channel = frame.getChannel();
        switch (frame.getType()) {
            case CONTROL: {
                int controlType = dec.readUint16();
                Method control = Method.create(controlType);
                control.read(dec);
                this.emit(channel, control);
                break;
            }
            case COMMAND: {
                int commandType = dec.readUint16();
                int hdr = dec.readUint16();
                Method command = Method.create(commandType);
                command.setSync((1 & hdr) != 0);
                command.read(dec);
                if (command.hasPayload() && !frame.isLastSegment()) {
                    this.setIncompleteCommand(channel, command);
                    break;
                }
                this.emit(channel, command);
                break;
            }
            case HEADER: {
                Method command = this.getIncompleteCommand(channel);
                ArrayList<Struct> structs = null;
                DeliveryProperties deliveryProps = null;
                MessageProperties messageProps = null;
                while (dec.hasRemaining()) {
                    Struct struct = dec.readStruct32();
                    if (struct instanceof DeliveryProperties && deliveryProps == null) {
                        deliveryProps = (DeliveryProperties)struct;
                        continue;
                    }
                    if (struct instanceof MessageProperties && messageProps == null) {
                        messageProps = (MessageProperties)struct;
                        continue;
                    }
                    if (structs == null) {
                        structs = new ArrayList<Struct>(2);
                    }
                    structs.add(struct);
                }
                command.setHeader(new Header(deliveryProps, messageProps, structs));
                if (!frame.isLastSegment()) break;
                this.setIncompleteCommand(channel, null);
                this.emit(channel, command);
                break;
            }
            case BODY: {
                Method command = this.getIncompleteCommand(channel);
                command.setBody(segment);
                this.setIncompleteCommand(channel, null);
                this.emit(channel, command);
                break;
            }
            default: {
                throw new IllegalStateException("unknown frame type: " + (Object)((Object)frame.getType()));
            }
        }
        dec.releaseBuffer();
    }

    private void setIncompleteCommand(int channelId, Method incomplete) {
        if ((channelId & 0xFF) == channelId) {
            this._incompleteMethodArray[channelId] = incomplete;
        } else if (incomplete != null) {
            this._incompleteMethodMap.put(channelId, incomplete);
        } else {
            this._incompleteMethodMap.remove(channelId);
        }
    }

    private Method getIncompleteCommand(int channelId) {
        if ((channelId & 0xFF) == channelId) {
            return this._incompleteMethodArray[channelId];
        }
        return this._incompleteMethodMap.get(channelId);
    }
}

