/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import org.switchyard.config.Configuration;
import org.switchyard.config.util.QNames;

public final class Configurations {
    private Configurations() {
    }

    public static Configuration merge(Configuration fromConfig, Configuration toConfig) {
        return Configurations.merge(fromConfig, toConfig, true);
    }

    public static Configuration merge(Configuration fromConfig, Configuration toConfig, boolean fromOverridesTo) {
        QName toConfigQName;
        QName fromConfigQName = fromConfig.getQName();
        if (!fromConfigQName.equals(toConfigQName = toConfig.getQName())) {
            throw new IllegalArgumentException(fromConfigQName + " != " + toConfigQName);
        }
        Configuration mergedConfig = toConfig.copy();
        Configurations.recursiveMerge(fromConfig.copy(), mergedConfig, fromOverridesTo);
        mergedConfig.normalize();
        return mergedConfig;
    }

    private static void recursiveMerge(Configuration from_config, Configuration merged_config, boolean from_overrides_merged) {
        String from_config_value;
        String from_config_attr_value;
        ArrayList<QName> merged_attr_qnames = new ArrayList<QName>();
        for (QName merged_config_attr_qname : merged_config.getAttributeQNames()) {
            if (from_overrides_merged) {
                from_config_attr_value = from_config.getAttribute(merged_config_attr_qname);
                if (from_config_attr_value == null) continue;
                merged_config.setAttribute(merged_config_attr_qname, from_config_attr_value);
                merged_attr_qnames.add(merged_config_attr_qname);
                continue;
            }
            merged_attr_qnames.add(merged_config_attr_qname);
        }
        for (QName from_config_attr_qname : from_config.getAttributeQNames()) {
            if (merged_attr_qnames.contains(from_config_attr_qname)) continue;
            from_config_attr_value = from_config.getAttribute(from_config_attr_qname);
            merged_config.setAttribute(from_config_attr_qname, from_config_attr_value);
            merged_attr_qnames.add(from_config_attr_qname);
        }
        if (from_overrides_merged && (from_config_value = from_config.getValue()) != null && from_config_value.length() > 0) {
            merged_config.setValue(from_config_value);
        }
        LinkedHashMap<Key, Configuration> merged_config_orphans = new LinkedHashMap<Key, Configuration>();
        for (Configuration merged_config_child : merged_config.getChildren()) {
            Key merged_config_child_key = new Key(merged_config_child);
            merged_config_orphans.put(merged_config_child_key, merged_config_child);
        }
        merged_config.removeChildren();
        for (Configuration from_config_child : from_config.getChildren()) {
            Key from_config_child_key = new Key(from_config_child);
            Configuration merged_config_orphan = (Configuration)merged_config_orphans.remove(from_config_child_key);
            if (merged_config_orphan != null) {
                Configurations.recursiveMerge(from_config_child, merged_config_orphan, from_overrides_merged);
                merged_config.addChild(merged_config_orphan);
                continue;
            }
            merged_config.addChild(from_config_child);
        }
        for (Configuration merged_config_orphan : merged_config_orphans.values()) {
            merged_config.addChild(merged_config_orphan);
        }
        merged_config.orderChildren();
    }

    private static final class Key {
        private static final String[] ID_CANDIDATES = new String[]{"id", "name", "class", "interface"};
        private QName _qname;
        private Object _id;

        private Key(Configuration config) {
            this._qname = config.getQName();
            for (String idc : ID_CANDIDATES) {
                this._id = this.id(config.getAttribute(QNames.create(this._qname.getNamespaceURI(), idc)));
                if (this._id == null) {
                    this._id = this.id(config.getAttribute(idc));
                }
                if (this._id != null) break;
            }
        }

        private String id(String str) {
            if (str != null && (str = str.trim()).length() == 0) {
                str = null;
            }
            return str;
        }

        public String toString() {
            return "Key [_qname=" + this._qname + ", _id=" + this._id + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._qname == null ? 0 : this._qname.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
                return false;
            }
            return !(this._qname == null ? other._qname != null : !this._qname.equals(other._qname));
        }
    }
}

