/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public final class Classes {
    private Classes() {
    }

    public static Class<?> forName(String name) {
        return Classes.forName(name, (ClassLoader)null);
    }

    public static Class<?> forName(String name, Class<?> caller) {
        return Classes.forName(name, caller != null ? caller.getClassLoader() : null);
    }

    public static Class<?> forName(String name, ClassLoader loader) {
        Class<?> c = null;
        List<ClassLoader> loaders = Classes.getClassLoaders(loader);
        for (ClassLoader cl : loaders) {
            try {
                c = Class.forName(name, true, cl);
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return c;
    }

    public static URL getResource(String path) throws IOException {
        return Classes.getResource(path, (ClassLoader)null);
    }

    public static URL getResource(String path, Class<?> caller) throws IOException {
        return Classes.getResource(path, caller != null ? caller.getClassLoader() : null);
    }

    public static URL getResource(String path, ClassLoader loader) throws IOException {
        List<URL> urls = Classes.getResources(path, loader);
        return urls.size() > 0 ? urls.get(0) : null;
    }

    public static List<URL> getResources(String path) throws IOException {
        return Classes.getResources(path, (ClassLoader)null);
    }

    public static List<URL> getResources(String path, Class<?> caller) throws IOException {
        return Classes.getResources(path, caller != null ? caller.getClassLoader() : null);
    }

    public static List<URL> getResources(String path, ClassLoader loader) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (path != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            for (ClassLoader cl : Classes.getClassLoaders(loader)) {
                Enumeration<URL> e = cl.getResources(path);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    if (urls.contains(url)) continue;
                    urls.add(url);
                }
            }
        }
        return urls;
    }

    public static InputStream getResourceAsStream(String path) throws IOException {
        return Classes.getResourceAsStream(path, (ClassLoader)null);
    }

    public static InputStream getResourceAsStream(String path, Class<?> caller) throws IOException {
        return Classes.getResourceAsStream(path, caller != null ? caller.getClassLoader() : null);
    }

    public static InputStream getResourceAsStream(String path, ClassLoader loader) throws IOException {
        URL url = Classes.getResource(path, loader);
        return url != null ? url.openStream() : null;
    }

    private static List<ClassLoader> getClassLoaders(ClassLoader loader) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(4);
        ClassLoader cl = Classes.getTCCL();
        if (cl != null) {
            loaders.add(cl);
        }
        if (loader != null) {
            loaders.add(loader);
        }
        if ((cl = Classes.class.getClassLoader()) != null) {
            loaders.add(cl);
        }
        if ((cl = Class.class.getClassLoader()) != null) {
            loaders.add(cl);
        }
        return loaders;
    }

    public static ClassLoader getTCCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader setTCCL(ClassLoader replacement) {
        Thread thread = Thread.currentThread();
        ClassLoader previous = thread.getContextClassLoader();
        thread.setContextClassLoader(replacement);
        return previous;
    }
}

