/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.switchyard.config.Configuration;
import org.switchyard.config.OutputKey;

public abstract class BaseConfiguration
implements Configuration {
    protected static final String DEFAULT_XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    protected static final String DEFAULT_XMLNS_PFX = "ns0";
    protected static final String NULL_NS_URI = "";

    @Override
    public Set<String> getNamespaces() {
        TreeSet<String> set = new TreeSet<String>();
        set.add(DEFAULT_XMLNS_URI);
        String ns = this.getQName().getNamespaceURI();
        if (ns != null && ns.length() > 0 && !set.contains(ns)) {
            set.add(ns);
        }
        for (QName attr_qname : this.getAttributeQNames()) {
            String attr_ns = attr_qname.getNamespaceURI();
            if (attr_ns == null || attr_ns.length() <= 0 || set.contains(attr_ns)) continue;
            set.add(attr_ns);
        }
        for (Configuration child : this.getChildren()) {
            Set<String> child_set = child.getNamespaces();
            for (String child_ns : child_set) {
                if (set.contains(child_ns)) continue;
                set.add(child_ns);
            }
        }
        return set;
    }

    @Override
    public Map<String, String> getNamespacePrefixMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(DEFAULT_XMLNS_URI, DEFAULT_XMLNS_PFX);
        int i = 1;
        for (String ns : this.getNamespaces()) {
            if (!map.containsKey(ns)) {
                map.put(ns, "ns" + i);
            }
            ++i;
        }
        return map;
    }

    @Override
    public Map<String, String> getPrefixNamespaceMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Map<String, String> nsp_map = this.getNamespacePrefixMap();
        for (Map.Entry<String, String> nsp_entry : nsp_map.entrySet()) {
            String pfx = nsp_entry.getValue();
            String ns = nsp_entry.getKey();
            if (map.containsKey(pfx)) continue;
            map.put(pfx, ns);
        }
        return map;
    }

    @Override
    public Configuration orderChildren() {
        return this.orderChildren(true);
    }

    @Override
    public Configuration orderChildren(boolean recursive) {
        String[] childrenGroups = this.getChildrenOrder();
        if (childrenGroups != null && childrenGroups.length > 0) {
            LinkedHashMap<String, ArrayList<Configuration>> config_map = new LinkedHashMap<String, ArrayList<Configuration>>();
            for (String childrenGroup : childrenGroups) {
                for (Configuration selected_config : this.getChildrenMatches(childrenGroup)) {
                    ArrayList<Configuration> config_list = (ArrayList<Configuration>)config_map.get(childrenGroup);
                    if (config_list == null) {
                        config_list = new ArrayList<Configuration>();
                        config_map.put(childrenGroup, config_list);
                    }
                    config_list.add(selected_config);
                }
                this.removeChildrenMatches(childrenGroup);
            }
            ArrayList<Configuration> config_remainder_list = new ArrayList<Configuration>();
            for (Configuration config_remainder : this.getChildren()) {
                config_remainder_list.add(config_remainder);
            }
            this.removeChildren();
            for (List config_list : config_map.values()) {
                for (Configuration selected_config : config_list) {
                    this.addChild(selected_config);
                }
            }
            for (Configuration config_remainder : config_remainder_list) {
                this.addChild(config_remainder);
            }
        }
        if (recursive) {
            for (Configuration child_config : this.getChildren()) {
                child_config.orderChildren(true);
            }
        }
        return this;
    }

    @Override
    public void write(OutputStream out, OutputKey ... keys) throws IOException {
        this.write(new OutputStreamWriter(out), keys);
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer, OutputKey.EXCLUDE_XML_DECLARATION);
            return writer.toString().trim();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

