/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.util.Comparator;

class NamespaceComparator
implements Comparator<String> {
    private static final String W3 = "http://www.w3.org/";
    private static final String OASIS_WSS = "http://docs.oasis-open.org/wss/";
    private static final String OASIS_NS = "http://docs.oasis-open.org/ns/";
    private static final String SY = "urn:switchyard-";
    private static final String SY_CFG = "urn:switchyard-config:";
    private static final String SY_CFG_SY = "urn:switchyard-config:switchyard";
    private static final String SY_COMP = "urn:switchyard-component-";

    NamespaceComparator() {
    }

    @Override
    public int compare(String o1, String o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.startsWith(W3)) {
            if (!o2.startsWith(W3)) {
                return -1;
            }
        } else if (o1.startsWith(OASIS_WSS)) {
            if (o2.startsWith(W3)) {
                return 1;
            }
            if (!o2.startsWith(OASIS_WSS)) {
                return -1;
            }
        } else if (o1.startsWith(OASIS_NS)) {
            if (o2.startsWith(W3) || o2.startsWith(OASIS_WSS)) {
                return 1;
            }
            if (!o2.startsWith(OASIS_NS)) {
                return -1;
            }
        } else if (o1.startsWith(SY)) {
            if (o2.startsWith(W3) || o2.startsWith(OASIS_WSS) || o2.startsWith(OASIS_NS)) {
                return 1;
            }
            if (o1.startsWith(SY_CFG)) {
                if (!o2.startsWith(SY_CFG)) {
                    return -1;
                }
                if (o1.startsWith(SY_CFG_SY) && !o2.startsWith(SY_CFG_SY)) {
                    return -1;
                }
                if (o2.startsWith(SY_CFG_SY) && !o1.startsWith(SY_CFG_SY)) {
                    return 1;
                }
            }
            if (o1.startsWith(SY_COMP) && !o2.startsWith(SY_COMP)) {
                return -1;
            }
            if (!o2.startsWith(SY)) {
                return -1;
            }
        } else if (o2.startsWith(W3) || o2.startsWith(OASIS_WSS) || o2.startsWith(OASIS_NS) || o2.startsWith(SY)) {
            return 1;
        }
        return o1.compareTo(o2) * -1;
    }
}

