/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.common.io.pull.ElementPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.config.BaseConfiguration;
import org.switchyard.config.Configuration;
import org.switchyard.config.OutputKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMConfiguration
extends BaseConfiguration {
    private static final String CHILDREN_ORDER_KEY = "childrenOrder";
    private static final String CHILDREN_ORDER_DELIM = ",";
    private Element _element;
    private Element _parent_element;
    private DOMConfiguration _parent_config;

    DOMConfiguration(Element element) {
        this._element = new ElementPuller().pull(element);
        this.getParent();
    }

    private DOMConfiguration(Element element, boolean normalize) {
        this._element = new ElementPuller().pull(element, normalize);
        this.getParent();
    }

    private DOMConfiguration(Configuration from) {
        DOMConfiguration config;
        if (from instanceof DOMConfiguration) {
            config = (DOMConfiguration)from;
        } else {
            Element element = new ElementPuller().pull(from.getQName());
            config = new DOMConfiguration(element);
            for (QName qname : from.getAttributeQNames()) {
                config.setAttribute(qname, from.getAttribute(qname));
            }
            for (Configuration grandchild : from.getChildren()) {
                config.addChild(grandchild);
            }
        }
        this._element = config._element;
        this.getParent();
    }

    @Override
    public String getName() {
        return XMLHelper.nameOf((Node)this._element);
    }

    @Override
    public QName getQName() {
        return XMLHelper.createQName((Element)this._element);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this._element.lookupNamespaceURI(prefix);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this._element.lookupPrefix(namespaceURI);
    }

    @Override
    public String getValue() {
        Node text_node = this.getTextNode(false);
        if (text_node instanceof Text) {
            return ((Text)text_node).getWholeText();
        }
        if (text_node != null) {
            return text_node.getNodeValue();
        }
        return null;
    }

    @Override
    public Configuration setValue(String value) {
        if (value != null) {
            Node text_node = this.getTextNode(true);
            text_node.setNodeValue(value);
        } else {
            Node text_node = this.getTextNode(false);
            if (text_node != null) {
                this._element.removeChild(text_node);
            }
        }
        return this;
    }

    private Node getTextNode(boolean create) {
        Node first_child_node = this._element.getFirstChild();
        if (first_child_node != null) {
            if (first_child_node.getNodeType() == 3) {
                return first_child_node;
            }
            for (Node next_child_node = first_child_node.getNextSibling(); next_child_node != null; next_child_node = next_child_node.getNextSibling()) {
                if (next_child_node.getNodeType() != 3) continue;
                return next_child_node;
            }
            if (create) {
                Text text_node = this._element.getOwnerDocument().createTextNode("");
                this._element.insertBefore(text_node, first_child_node);
                return text_node;
            }
        }
        if (create) {
            Text text_node = this._element.getOwnerDocument().createTextNode("");
            this._element.appendChild(text_node);
            return text_node;
        }
        return null;
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        NamedNodeMap attrs = this._element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String name = XMLHelper.nameOf((Node)attr);
            names.add(name);
        }
        return names;
    }

    @Override
    public List<QName> getAttributeQNames() {
        ArrayList<QName> qnames = new ArrayList<QName>();
        NamedNodeMap attrs = this._element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String name = XMLHelper.nameOf((Node)attr);
            if (name == null || name.length() <= 0) continue;
            qnames.add(XMLHelper.createQName((String)attr.getNamespaceURI(), (String)name, (String)attr.getPrefix()));
        }
        return qnames;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name != null) {
            return this._element.hasAttribute(name);
        }
        return false;
    }

    @Override
    public boolean hasAttribute(QName qname) {
        if (qname != null) {
            String namespaceURI = qname.getNamespaceURI();
            String localPart = qname.getLocalPart();
            if (namespaceURI != null && !namespaceURI.equals("")) {
                return this._element.hasAttributeNS(namespaceURI, localPart);
            }
            return this.hasAttribute(localPart);
        }
        return false;
    }

    @Override
    public String getAttribute(String name) {
        if (name != null) {
            String value = this._element.getAttribute(name);
            return "".equals(value) ? null : value;
        }
        return null;
    }

    @Override
    public String getAttribute(QName qname) {
        if (qname != null) {
            String namespaceURI = qname.getNamespaceURI();
            String localPart = qname.getLocalPart();
            if (namespaceURI != null && !namespaceURI.equals("")) {
                Attr attr = this._element.getAttributeNodeNS(namespaceURI, localPart);
                if (attr != null) {
                    String value = attr.getValue();
                    return "".equals(value) ? null : value;
                }
            } else {
                return this.getAttribute(localPart);
            }
        }
        return null;
    }

    @Override
    public Configuration setAttribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (value == null) {
            this._element.removeAttribute(name);
        } else {
            this._element.setAttribute(name, value);
        }
        return this;
    }

    @Override
    public Configuration setAttribute(QName qname, String value) {
        String localPart;
        if (qname == null) {
            throw new IllegalArgumentException("qname == null");
        }
        String namespaceURI = qname.getNamespaceURI();
        Attr attr = this._element.getAttributeNodeNS(namespaceURI, localPart = qname.getLocalPart());
        if (attr != null) {
            if (value == null) {
                this._element.removeAttributeNode(attr);
            } else {
                attr.setValue(value);
            }
        } else if (value != null && !"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            attr = this._element.getOwnerDocument().createAttributeNS(namespaceURI, localPart);
            String prefix = qname.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                attr.setPrefix(prefix);
            }
            attr.setValue(value);
            this._element.setAttributeNode(attr);
        }
        return this;
    }

    @Override
    public boolean hasParent() {
        return this._element.getParentNode() instanceof Element;
    }

    @Override
    public Configuration getParent() {
        Node node = this._element.getParentNode();
        if (node instanceof Element) {
            Element e = (Element)node;
            if (this._parent_element != null && this._parent_element != e) {
                this._parent_config = null;
            }
            if (this._parent_config == null) {
                this._parent_config = new DOMConfiguration(e, false);
                this._parent_element = e;
            }
        }
        return this._parent_config;
    }

    @Override
    public boolean hasChildren() {
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChildren(String name) {
        if (name != null) {
            NodeList nodes = this._element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                String node_name;
                Node node = nodes.item(i);
                if (node == null || node.getNodeType() != 1 || !(node_name = XMLHelper.nameOf((Node)node)).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasChildren(QName qname) {
        if (qname != null) {
            NodeList nodes = this._element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                QName node_qname;
                Node node = nodes.item(i);
                if (node == null || node.getNodeType() != 1 || !(node_qname = XMLHelper.createQName((Element)((Element)node))).equals(qname)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Configuration> getChildren() {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1) continue;
            configs.add(new DOMConfiguration((Element)node));
        }
        return configs;
    }

    @Override
    public List<Configuration> getChildren(String name) {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || !XMLHelper.nameOf((Node)node).equals(name)) continue;
            configs.add(new DOMConfiguration((Element)node));
        }
        return configs;
    }

    @Override
    public List<Configuration> getChildrenStartsWith(String name) {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || !XMLHelper.nameOf((Node)node).startsWith(name)) continue;
            configs.add(new DOMConfiguration((Element)node));
        }
        return configs;
    }

    @Override
    public List<Configuration> getChildrenMatches(String regexp) {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || !XMLHelper.nameOf((Node)node).matches(regexp)) continue;
            configs.add(new DOMConfiguration((Element)node));
        }
        return configs;
    }

    @Override
    public List<Configuration> getChildren(QName qname) {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        for (int i = 0; i < nodes.getLength(); ++i) {
            configs.add(new DOMConfiguration((Element)nodes.item(i)));
        }
        return configs;
    }

    @Override
    public Configuration getFirstChild(String name) {
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || !XMLHelper.nameOf((Node)node).equals(name)) continue;
            return new DOMConfiguration((Element)node);
        }
        return null;
    }

    @Override
    public Configuration getFirstChildStartsWith(String name) {
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || !XMLHelper.nameOf((Node)node).startsWith(name)) continue;
            return new DOMConfiguration((Element)node);
        }
        return null;
    }

    @Override
    public Configuration getFirstChild(QName qname) {
        Node node;
        NodeList nodes = this._element.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        if (nodes.getLength() > 0 && (node = nodes.item(0)) != null && node.getNodeType() == 1) {
            return new DOMConfiguration((Element)node);
        }
        return null;
    }

    @Override
    public Configuration addChild(Configuration child) {
        String this_xmlns;
        Document this_doc = this._element.getOwnerDocument();
        this_doc.normalizeDocument();
        DOMConfiguration child_config = new DOMConfiguration(child);
        Document child_doc = child_config._element.getOwnerDocument();
        if (child_doc != this_doc) {
            child_doc.normalizeDocument();
            this_doc.adoptNode(child_config._element);
        }
        this._element.appendChild(child_config._element);
        String child_xmlns = Strings.trimToNull((String)child_config._element.getNamespaceURI());
        if (child_xmlns == null && (this_xmlns = Strings.trimToNull((String)this._element.getNamespaceURI())) != null) {
            this_doc.renameNode(child_config._element, this_xmlns, child_config.getName());
        }
        return this;
    }

    @Override
    public Configuration removeChildren() {
        ArrayList<Node> removals = new ArrayList<Node>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1) continue;
            removals.add(node);
        }
        for (Node node : removals) {
            this._element.removeChild(node);
        }
        return this;
    }

    @Override
    public Configuration removeChildren(String name) {
        ArrayList<Node> removals = new ArrayList<Node>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || !XMLHelper.nameOf((Node)node).equals(name)) continue;
            removals.add(node);
        }
        for (Node node : removals) {
            this._element.removeChild(node);
        }
        return this;
    }

    @Override
    public Configuration removeChildrenStartsWith(String name) {
        ArrayList<Node> removals = new ArrayList<Node>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || !XMLHelper.nameOf((Node)node).startsWith(name)) continue;
            removals.add(node);
        }
        for (Node node : removals) {
            this._element.removeChild(node);
        }
        return this;
    }

    @Override
    public Configuration removeChildrenMatches(String regexp) {
        ArrayList<Node> removals = new ArrayList<Node>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || !XMLHelper.nameOf((Node)node).matches(regexp)) continue;
            removals.add(node);
        }
        for (Node node : removals) {
            this._element.removeChild(node);
        }
        return this;
    }

    @Override
    public Configuration removeChildren(QName qname) {
        ArrayList<Node> removals = new ArrayList<Node>();
        NodeList nodes = this._element.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1) continue;
            removals.add(node);
        }
        for (Node node : removals) {
            this._element.removeChild(node);
        }
        return this;
    }

    @Override
    public String[] getChildrenOrder() {
        String co = (String)this._element.getUserData(CHILDREN_ORDER_KEY);
        return Strings.splitTrimToNullArray((String)co, (String)CHILDREN_ORDER_DELIM);
    }

    @Override
    public Configuration setChildrenOrder(String ... childrenOrder) {
        String co = Strings.concat((String)CHILDREN_ORDER_DELIM, (String[])childrenOrder);
        this._element.setUserData(CHILDREN_ORDER_KEY, co, null);
        return this;
    }

    @Override
    public Configuration copy() {
        Element clone = (Element)this._element.cloneNode(true);
        DOMConfiguration copy = new DOMConfiguration(clone, false);
        copy.setChildrenOrder(this.getChildrenOrder());
        return copy;
    }

    @Override
    public Configuration normalize() {
        this._element.normalize();
        return this;
    }

    @Override
    public void write(Writer writer, OutputKey ... keys) throws IOException {
        List<OutputKey> key_list = Arrays.asList(keys);
        if (key_list.contains((Object)OutputKey.NORMALIZE)) {
            this.normalize();
        }
        if (key_list.contains((Object)OutputKey.ORDER_CHILDREN)) {
            this.orderChildren();
        }
        HashMap<String, String> outputProperties = new HashMap<String, String>();
        if (key_list.contains((Object)OutputKey.OMIT_XML_DECLARATION)) {
            outputProperties.put("omit-xml-declaration", "yes");
        }
        if (key_list.contains((Object)OutputKey.PRETTY_PRINT)) {
            outputProperties.put(OutputKey.PRETTY_PRINT.hint(), "yes");
        }
        XMLHelper.write((Node)this._element, (Writer)writer, outputProperties);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._element == null ? 0 : this._element.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMConfiguration other = (DOMConfiguration)obj;
        if (this._element == null) {
            if (other._element != null) {
                return false;
            }
        } else {
            this._element.normalize();
            other._element.normalize();
            if (!this._element.isEqualNode(other._element)) {
                return false;
            }
        }
        return true;
    }
}

