/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;

public class V1ComponentModel
extends BaseNamedModel
implements ComponentModel {
    private ComponentImplementationModel _implementation;
    private List<ComponentServiceModel> _services = new ArrayList<ComponentServiceModel>();
    private List<ComponentReferenceModel> _references = new ArrayList<ComponentReferenceModel>();

    public V1ComponentModel() {
        super(new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "component"));
        this.setModelChildrenOrder("implementation.*", "service", "reference");
    }

    public V1ComponentModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration service_config : config.getChildren("service")) {
            ComponentServiceModel service = (ComponentServiceModel)this.readModel(service_config);
            if (service == null) continue;
            this._services.add(service);
        }
        for (Configuration reference_config : config.getChildren("reference")) {
            ComponentReferenceModel reference = (ComponentReferenceModel)this.readModel(reference_config);
            if (reference == null) continue;
            this._references.add(reference);
        }
        this.setModelChildrenOrder("implementation.*", "service", "reference");
    }

    @Override
    public CompositeModel getComposite() {
        return (CompositeModel)this.getModelParent();
    }

    @Override
    public ComponentImplementationModel getImplementation() {
        if (this._implementation == null) {
            this._implementation = (ComponentImplementationModel)this.getFirstChildModelStartsWith("implementation");
        }
        return this._implementation;
    }

    @Override
    public ComponentModel setImplementation(ComponentImplementationModel implementation) {
        this.setChildModel(implementation);
        this._implementation = implementation;
        return this;
    }

    @Override
    public synchronized List<ComponentServiceModel> getServices() {
        return Collections.unmodifiableList(this._services);
    }

    @Override
    public synchronized ComponentModel addService(ComponentServiceModel service) {
        this.addChildModel(service);
        this._services.add(service);
        return this;
    }

    @Override
    public synchronized List<ComponentReferenceModel> getReferences() {
        return Collections.unmodifiableList(this._references);
    }

    @Override
    public synchronized ComponentModel addReference(ComponentReferenceModel reference) {
        this.addChildModel(reference);
        this._references.add(reference);
        return this;
    }
}

