/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseMarshaller;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1BindingModel;
import org.switchyard.config.model.composite.v1.V1ComponentImplementationModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentReferenceModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1CompositeReferenceModel;
import org.switchyard.config.model.composite.v1.V1CompositeServiceModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.composite.v1.V1SCABindingModel;
import org.switchyard.config.model.property.v1.V1PropertyModel;

public class V1CompositeMarshaller
extends BaseMarshaller {
    public V1CompositeMarshaller(Descriptor desc) {
        super(desc);
    }

    @Override
    public Model read(Configuration config) {
        String name = config.getName();
        Descriptor desc = this.getDescriptor();
        if (name.equals("composite")) {
            return new V1CompositeModel(config, desc);
        }
        if (name.equals("service")) {
            Configuration config_parent = config.getParent();
            if (config_parent != null) {
                if (config_parent.getName().equals("composite")) {
                    return new V1CompositeServiceModel(config, desc);
                }
                if (config_parent.getName().equals("component")) {
                    return new V1ComponentServiceModel(config, desc);
                }
            }
        } else {
            if (name.startsWith("binding")) {
                if (name.endsWith(".sca")) {
                    return new V1SCABindingModel(config, desc);
                }
                return new V1BindingModel(config, desc);
            }
            if (name.equals("component")) {
                return new V1ComponentModel(config, desc);
            }
            if (name.startsWith("implementation")) {
                return new V1ComponentImplementationModel(config, desc);
            }
            if (name.startsWith("interface")) {
                Configuration config_parent = config.getParent();
                if (config_parent != null && (name.endsWith("java") || name.endsWith("wsdl"))) {
                    return new V1InterfaceModel(config, desc);
                }
            } else if (name.equals("reference")) {
                Configuration config_parent = config.getParent();
                if (config_parent != null) {
                    if (config_parent.getName().equals("composite")) {
                        return new V1CompositeReferenceModel(config, desc);
                    }
                    if (config_parent.getName().equals("component")) {
                        return new V1ComponentReferenceModel(config, desc);
                    }
                }
            } else if (name.equals("property")) {
                return new V1PropertyModel(config, desc);
            }
        }
        return null;
    }
}

