/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.common.property.CompoundPropertyResolver;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.property.SystemAndTestPropertyResolver;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.property.PropertyModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;

public class V1CompositeModel
extends BaseNamedModel
implements CompositeModel {
    private List<CompositeServiceModel> _services = new ArrayList<CompositeServiceModel>();
    private List<CompositeReferenceModel> _references = new ArrayList<CompositeReferenceModel>();
    private List<ComponentModel> _components = new ArrayList<ComponentModel>();
    private Map<String, PropertyModel> _properties = new HashMap<String, PropertyModel>();

    public V1CompositeModel() {
        super(new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "composite"));
        this.setModelChildrenOrder("service", "reference", "component", "property");
        this.setCompositePropertyResolver();
    }

    public V1CompositeModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration service_config : config.getChildren("service")) {
            CompositeServiceModel service = (CompositeServiceModel)this.readModel(service_config);
            if (service == null) continue;
            this._services.add(service);
        }
        for (Configuration reference_config : config.getChildren("reference")) {
            CompositeReferenceModel reference = (CompositeReferenceModel)this.readModel(reference_config);
            if (reference == null) continue;
            this._references.add(reference);
        }
        for (Configuration component_config : config.getChildren("component")) {
            ComponentModel component = (ComponentModel)this.readModel(component_config);
            if (component == null) continue;
            this._components.add(component);
        }
        for (Configuration property_config : config.getChildren("property")) {
            PropertyModel property = (PropertyModel)this.readModel(property_config);
            if (property == null) continue;
            this._properties.put(property.getName(), property);
        }
        this.setModelChildrenOrder("service", "reference", "component", "property");
        this.setCompositePropertyResolver();
    }

    @Override
    public SwitchYardModel getSwitchYard() {
        return (SwitchYardModel)this.getModelParent();
    }

    @Override
    public synchronized List<CompositeReferenceModel> getReferences() {
        return Collections.unmodifiableList(this._references);
    }

    @Override
    public synchronized CompositeModel addReference(CompositeReferenceModel reference) {
        this.addChildModel(reference);
        this._references.add(reference);
        return this;
    }

    @Override
    public synchronized List<CompositeServiceModel> getServices() {
        return Collections.unmodifiableList(this._services);
    }

    @Override
    public synchronized CompositeModel addService(CompositeServiceModel service) {
        this.addChildModel(service);
        this._services.add(service);
        return this;
    }

    @Override
    public synchronized List<ComponentModel> getComponents() {
        return Collections.unmodifiableList(this._components);
    }

    @Override
    public synchronized CompositeModel addComponent(ComponentModel component) {
        this.addChildModel(component);
        this._components.add(component);
        return this;
    }

    @Override
    public void setTargetNamespace(String namespaceUri) {
        this.setModelAttribute("targetNamespace", namespaceUri);
    }

    @Override
    public synchronized PropertyModel getProperty(String name) {
        return this._properties.get(name);
    }

    @Override
    public synchronized Map<String, PropertyModel> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    @Override
    public V1CompositeModel addProperty(PropertyModel property) {
        this.addChildModel(property);
        this._properties.put(property.getName(), property);
        return this;
    }

    public Object resolveProperty(String key) {
        PropertyModel property = this.getProperty(key);
        return property != null ? property.getValue() : null;
    }

    @Override
    public void setCompositePropertyResolver() {
        CompoundPropertyResolver pr;
        Configuration parent = this.getModelConfiguration().getParent();
        if (parent != null) {
            pr = new CompoundPropertyResolver(new PropertyResolver[]{parent.getPropertyResolver(), this});
            this.getModelConfiguration().setPropertyResolver((PropertyResolver)pr);
        } else {
            pr = new CompoundPropertyResolver(new PropertyResolver[]{SystemAndTestPropertyResolver.instance(), this});
            this.getModelConfiguration().setPropertyResolver((PropertyResolver)pr);
        }
        for (ComponentModel component : this._components) {
            component.setComponentPropertyResolver();
        }
    }
}

