/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.common.lang.Strings;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.ExtensionsModel;
import org.switchyard.config.model.composite.InterfaceModel;

public class V1CompositeServiceModel
extends BaseNamedModel
implements CompositeServiceModel {
    private static final Logger LOGGER = Logger.getLogger(V1CompositeServiceModel.class);
    private List<BindingModel> _bindings = new ArrayList<BindingModel>();
    private InterfaceModel _interface;
    private ExtensionsModel _extensions;

    public V1CompositeServiceModel() {
        super(new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service"));
    }

    public V1CompositeServiceModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration binding_config : config.getChildrenStartsWith("binding")) {
            BindingModel binding = (BindingModel)this.readModel(binding_config);
            if (binding == null) continue;
            this._bindings.add(binding);
        }
    }

    @Override
    public CompositeModel getComposite() {
        return (CompositeModel)this.getModelParent();
    }

    @Override
    public ComponentModel getComponent() {
        String[] promote;
        CompositeModel composite = this.getComposite();
        if (composite != null && (promote = Strings.splitTrimToNullArray((String)this.getPromote(), (String)"/")).length > 0) {
            String componentName = promote[0];
            for (ComponentModel component : composite.getComponents()) {
                if (!componentName.equals(component.getName())) continue;
                return component;
            }
        }
        return null;
    }

    @Override
    public ComponentServiceModel getComponentService() {
        String[] promote;
        int count;
        CompositeModel composite = this.getComposite();
        if (composite != null && (count = (promote = Strings.splitTrimToNullArray((String)this.getPromote(), (String)"/")).length) > 0) {
            String componentName = promote[0];
            String componentServiceName = count == 2 ? promote[1] : null;
            boolean missingComponent = true;
            for (ComponentModel component : composite.getComponents()) {
                if (!componentName.equals(component.getName())) continue;
                missingComponent = false;
                List<ComponentServiceModel> services = component.getServices();
                if (count == 1) {
                    if (services.size() <= 0) break;
                    return services.get(0);
                }
                if (count != 2) continue;
                for (ComponentServiceModel service : services) {
                    if (!componentServiceName.equals(service.getName())) continue;
                    return service;
                }
                LOGGER.warn((Object)("missing component service [" + componentServiceName + "] for component [" + componentName + "]"));
            }
            LOGGER.warn((Object)("missing component service for " + (missingComponent ? "missing " : "") + "component [" + componentName + "]"));
        }
        return null;
    }

    @Override
    public String getPromote() {
        return this.getModelAttribute("promote");
    }

    @Override
    public CompositeServiceModel setPromote(String promote) {
        this.setModelAttribute("promote", promote);
        return this;
    }

    @Override
    public synchronized List<BindingModel> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public synchronized CompositeServiceModel addBinding(BindingModel binding) {
        this.addChildModel(binding);
        this._bindings.add(binding);
        return this;
    }

    @Override
    public InterfaceModel getInterface() {
        if (this._interface == null) {
            this._interface = (InterfaceModel)this.getFirstChildModelStartsWith("interface");
        }
        return this._interface;
    }

    @Override
    public CompositeServiceModel setInterface(InterfaceModel interfaze) {
        this.setChildModel(interfaze);
        this._interface = interfaze;
        return this;
    }

    @Override
    public ExtensionsModel getExtensions() {
        if (this._extensions == null) {
            this._extensions = (ExtensionsModel)this.getFirstChildModel("extensions");
        }
        return this._extensions;
    }

    @Override
    public CompositeServiceModel setExtensions(ExtensionsModel extensions) {
        this.setChildModel(extensions);
        this._extensions = extensions;
        return this;
    }
}

