/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.common.lang.Strings;
import org.switchyard.config.ConfigLogger;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.ExtensionsModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.SCANamespace;

public class V1CompositeServiceModel
extends BaseNamedModel
implements CompositeServiceModel {
    private List<BindingModel> _bindings = new ArrayList<BindingModel>();
    private InterfaceModel _interface;
    private ExtensionsModel _extensions;

    public V1CompositeServiceModel() {
        super(SCANamespace.DEFAULT.uri(), "service");
    }

    public V1CompositeServiceModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration binding_config : config.getChildrenStartsWith("binding")) {
            BindingModel binding = (BindingModel)this.readModel(binding_config);
            if (binding == null) continue;
            this._bindings.add(binding);
        }
    }

    @Override
    public CompositeModel getComposite() {
        return (CompositeModel)this.getModelParent();
    }

    @Override
    public ComponentServiceModel getComponentService() {
        CompositeModel composite = this.getComposite();
        if (composite != null) {
            String[] promotes = Strings.splitTrimToNullArray((String)this.getPromote(), (String)" ");
            switch (promotes.length) {
                case 0: {
                    break;
                }
                case 1: {
                    String[] names = Strings.splitTrimToNullArray((String)promotes[0], (String)"/");
                    int namesCount = names.length;
                    if (namesCount <= 0) break;
                    String componentName = names[0];
                    String componentServiceName = namesCount == 2 ? names[1] : null;
                    for (ComponentModel component : composite.getComponents()) {
                        if (!componentName.equals(component.getName())) continue;
                        List<ComponentServiceModel> componentServices = component.getServices();
                        if (namesCount == 1) {
                            ComponentServiceModel componentService;
                            if (componentServices.size() <= 0 || (componentService = componentServices.iterator().next()) == null) continue;
                            return componentService;
                        }
                        if (namesCount != 2) continue;
                        for (ComponentServiceModel componentService : componentServices) {
                            if (!componentServiceName.equals(componentService.getName()) || componentService == null) continue;
                            return componentService;
                        }
                    }
                    ConfigLogger.ROOT_LOGGER.missingComponentService(componentServiceName != null ? componentServiceName : "", componentName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("A composite service can only promote one component service.");
                }
            }
        }
        return null;
    }

    @Override
    public String getPromote() {
        return this.getModelAttribute("promote");
    }

    @Override
    public CompositeServiceModel setPromote(String promote) {
        this.setModelAttribute("promote", promote);
        return this;
    }

    @Override
    public synchronized List<BindingModel> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public synchronized CompositeServiceModel addBinding(BindingModel binding) {
        this.addChildModel(binding);
        this._bindings.add(binding);
        return this;
    }

    @Override
    public InterfaceModel getInterface() {
        if (this._interface == null) {
            this._interface = (InterfaceModel)this.getFirstChildModelStartsWith("interface");
        }
        return this._interface;
    }

    @Override
    public CompositeServiceModel setInterface(InterfaceModel interfaze) {
        this.setChildModel(interfaze);
        this._interface = interfaze;
        return this;
    }

    @Override
    public ExtensionsModel getExtensions() {
        if (this._extensions == null) {
            this._extensions = (ExtensionsModel)this.getFirstChildModel("extensions");
        }
        return this._extensions;
    }

    @Override
    public CompositeServiceModel setExtensions(ExtensionsModel extensions) {
        this.setChildModel(extensions);
        this._extensions = extensions;
        return this;
    }
}

