/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.config.Configuration;
import org.switchyard.config.OutputKey;

public abstract class BaseConfiguration
implements Configuration {
    @Override
    public Set<String> getNamespaces() {
        TreeSet<String> set = new TreeSet<String>();
        set.add("http://www.w3.org/2000/xmlns/");
        for (Configuration config = this; config != null; config = config.getParent()) {
            String ns = config.getQName().getNamespaceURI();
            if (ns != null && ns.length() > 0) {
                set.add(ns);
            }
            for (QName attr_qname : config.getAttributeQNames()) {
                String attr_value_ns;
                String attr_value_pfx;
                String attr_value;
                String attr_ns = attr_qname.getNamespaceURI();
                if (attr_ns != null && attr_ns.length() > 0) {
                    set.add(attr_ns);
                }
                if ((attr_value = config.getAttribute(attr_qname)) == null) continue;
                String attr_lp = attr_qname.getLocalPart();
                if ("xmlns".equals(attr_lp) || "http://www.w3.org/2000/xmlns/".equals(attr_ns) || "targetNamespace".equals(attr_lp)) {
                    set.add(attr_value);
                    continue;
                }
                int pos = attr_value.indexOf(58);
                if (pos <= -1 || (attr_value_pfx = Strings.trimToNull((String)attr_value.substring(0, pos))) == null || (attr_value_ns = this.lookupNamespaceURI(attr_value_pfx)) == null) continue;
                set.add(attr_value_ns);
            }
        }
        return set;
    }

    @Override
    public Set<String> getChildrenNamespaces() {
        TreeSet<String> set = new TreeSet<String>();
        List<Configuration> children = this.getChildren();
        if (children.size() > 0) {
            for (Configuration child : children) {
                set.addAll(child.getChildrenNamespaces());
            }
        } else {
            set.addAll(this.getNamespaces());
        }
        return set;
    }

    @Override
    public Map<String, String> getNamespacePrefixMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("http://www.w3.org/2000/xmlns/", "xmlns");
        int i = 0;
        for (String ns : this.getNamespaces()) {
            if (map.containsKey(ns)) continue;
            String pfx = this.lookupPrefix(ns);
            if (pfx == null) {
                boolean unavailable = true;
                while (unavailable) {
                    pfx = "ns" + i++;
                    unavailable = this.lookupNamespaceURI(pfx) != null;
                }
            }
            map.put(ns, pfx);
        }
        return map;
    }

    @Override
    public Map<String, String> getPrefixNamespaceMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Map<String, String> nsp_map = this.getNamespacePrefixMap();
        for (Map.Entry<String, String> nsp_entry : nsp_map.entrySet()) {
            String pfx = nsp_entry.getValue();
            String ns = nsp_entry.getKey();
            if (map.containsKey(pfx)) continue;
            map.put(pfx, ns);
        }
        return map;
    }

    @Override
    public QName getAttributeAsQName(String name) {
        return this.createAttributeQName(this.getAttribute(name));
    }

    @Override
    public QName getAttributeAsQName(QName qname) {
        return this.createAttributeQName(this.getAttribute(qname));
    }

    private QName createAttributeQName(String value) {
        String ns = null;
        String lp = null;
        String pfx = null;
        if (value != null) {
            QName qvalue = QName.valueOf(value);
            ns = qvalue.getNamespaceURI();
            if (ns.length() > 0) {
                lp = qvalue.getLocalPart();
                pfx = this.lookupPrefix(ns);
            } else {
                int pos = value.indexOf(58);
                if (pos > -1) {
                    String[] split = value.split(":", 2);
                    pfx = split.length > 0 ? split[0] : null;
                    String string = lp = split.length > 1 ? split[1] : null;
                    if (pfx != null) {
                        ns = this.lookupNamespaceURI(pfx);
                    }
                } else {
                    lp = value;
                }
            }
        }
        return XMLHelper.createQName(ns, lp, pfx);
    }

    @Override
    public Configuration setAttributeAsQName(String name, QName value) {
        return this.setAttribute(name, this.createAttributeValue(value));
    }

    @Override
    public Configuration setAttributeAsQName(QName qname, QName value) {
        return this.setAttribute(qname, this.createAttributeValue(value));
    }

    private String createAttributeValue(QName value) {
        if (value != null) {
            String lp = value.getLocalPart();
            String ns = value.getNamespaceURI();
            String pfx = this.lookupPrefix(ns);
            if (pfx != null) {
                return pfx + ":" + lp;
            }
            pfx = value.getPrefix();
            if (pfx.length() > 0 && this.lookupNamespaceURI(pfx) != null) {
                return pfx + ":" + lp;
            }
            if (ns.length() > 0) {
                return value.toString();
            }
            return lp;
        }
        return null;
    }

    @Override
    public Configuration getRoot() {
        Configuration root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    @Override
    public String getRootNamespace() {
        return this.getRoot().getQName().getNamespaceURI();
    }

    @Override
    public Configuration orderChildren() {
        return this.orderChildren(true);
    }

    @Override
    public Configuration orderChildren(boolean recursive) {
        String[] childrenGroups = this.getChildrenOrder();
        if (childrenGroups != null && childrenGroups.length > 0) {
            LinkedHashMap<String, ArrayList<Configuration>> config_map = new LinkedHashMap<String, ArrayList<Configuration>>();
            for (String childrenGroup : childrenGroups) {
                for (Configuration selected_config : this.getChildrenMatches(childrenGroup)) {
                    ArrayList<Configuration> config_list = (ArrayList<Configuration>)config_map.get(childrenGroup);
                    if (config_list == null) {
                        config_list = new ArrayList<Configuration>();
                        config_map.put(childrenGroup, config_list);
                    }
                    config_list.add(selected_config);
                }
                this.removeChildrenMatches(childrenGroup);
            }
            ArrayList<Configuration> config_remainder_list = new ArrayList<Configuration>();
            for (Configuration config_remainder : this.getChildren()) {
                config_remainder_list.add(config_remainder);
            }
            this.removeChildren();
            for (List config_list : config_map.values()) {
                for (Configuration selected_config : config_list) {
                    this.addChild(selected_config);
                }
            }
            for (Configuration config_remainder : config_remainder_list) {
                this.addChild(config_remainder);
            }
        }
        if (recursive) {
            for (Configuration child_config : this.getChildren()) {
                child_config.orderChildren(true);
            }
        }
        return this;
    }

    @Override
    public Source getSource(OutputKey ... keys) {
        return new StreamSource(new StringReader(this.getString(keys)));
    }

    @Override
    public String getString(OutputKey ... keys) {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer, keys);
            return writer.toString().trim();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void write(OutputStream out, OutputKey ... keys) throws IOException {
        this.write(new OutputStreamWriter(out), keys);
    }

    public String toString() {
        return this.getString(OutputKey.OMIT_XML_DECLARATION, OutputKey.PRETTY_PRINT);
    }
}

