/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.switchyard.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.switchyard.ArtifactModel;
import org.switchyard.config.model.switchyard.ArtifactsModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;

public class V1ArtifactsModel
extends BaseModel
implements ArtifactsModel {
    private List<ArtifactModel> _artifacts = new ArrayList<ArtifactModel>();

    public V1ArtifactsModel(String namespace) {
        super(new QName(namespace, "artifacts"));
        this.setModelChildrenOrder("artifact");
    }

    public V1ArtifactsModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration artifact_config : config.getChildrenStartsWith("artifact")) {
            ArtifactModel artifact = (ArtifactModel)this.readModel(artifact_config);
            if (artifact == null) continue;
            this._artifacts.add(artifact);
        }
        this.setModelChildrenOrder("artifact");
    }

    @Override
    public SwitchYardModel getSwitchYard() {
        return (SwitchYardModel)this.getModelParent();
    }

    @Override
    public synchronized List<ArtifactModel> getArtifacts() {
        return Collections.unmodifiableList(this._artifacts);
    }

    @Override
    public synchronized ArtifactsModel addArtifact(ArtifactModel artifact) {
        this.addChildModel(artifact);
        this._artifacts.add(artifact);
        return this;
    }

    @Override
    public ArtifactModel getArtifact(String name) {
        ArtifactModel artifact = null;
        for (ArtifactModel a : this._artifacts) {
            if (!a.getName().equals(name)) continue;
            artifact = a;
            break;
        }
        return artifact;
    }

    @Override
    public ArtifactModel removeArtifact(String artifactName) {
        ArtifactModel removed = null;
        for (ArtifactModel artifact : this._artifacts) {
            if (!artifact.getName().equals(artifactName)) continue;
            removed = artifact;
            this._artifacts.remove(artifact);
        }
        return removed;
    }
}

