/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.property.v2;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.io.pull.Puller;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.property.PropertiesModel;
import org.switchyard.config.model.property.v1.V1PropertiesModel;

public class V2PropertiesModel
extends V1PropertiesModel {
    private Properties _loadProperties = null;

    public V2PropertiesModel(String namespace) {
        super(namespace);
        this.loadProperies();
    }

    public V2PropertiesModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.loadProperies();
    }

    @Override
    public String getLoad() {
        return this.getModelAttribute("load");
    }

    @Override
    public PropertiesModel setLoad(String load) {
        this.setModelAttribute("load", load);
        this.loadProperies();
        return this;
    }

    private void loadProperies() {
        PropertiesPuller.PropertiesType propsType;
        PropertiesPuller propsPuller;
        Properties props;
        this._loadProperties = null;
        String propsPath = this.getLoad();
        if (propsPath != null && (props = (Properties)(propsPuller = new PropertiesPuller(propsType = propsPath.endsWith(".xml") ? PropertiesPuller.PropertiesType.XML : PropertiesPuller.PropertiesType.PROPERTIES)).pullPath(propsPath, this.getClass(), Puller.PathType.values())) != null) {
            this._loadProperties = props;
        }
    }

    @Override
    public String getPropertyValue(String name) {
        String prop = super.getPropertyValue(name);
        if (prop == null && name != null && this._loadProperties != null) {
            prop = this._loadProperties.getProperty(name);
        }
        return prop;
    }

    @Override
    public Properties toProperties() {
        Properties superProperties;
        Properties properties = new Properties();
        if (this._loadProperties != null) {
            for (Object key : this._loadProperties.keySet()) {
                String name = (String)key;
                String value = this._loadProperties.getProperty(name);
                properties.setProperty(name, value);
            }
        }
        if ((superProperties = super.toProperties()) != null) {
            for (Object key : superProperties.keySet()) {
                String name = (String)key;
                String value = superProperties.getProperty(name);
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this._loadProperties != null) {
            for (Object key : this._loadProperties.keySet()) {
                String name = (String)key;
                String value = this._loadProperties.getProperty(name);
                map.put(name, value);
            }
        }
        map.putAll(super.toMap());
        return map;
    }
}

