/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.clojure.deploy;

import clojure.lang.Compiler;
import clojure.lang.Var;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.Classes;
import org.switchyard.component.clojure.config.model.ClojureComponentImplementationModel;
import org.switchyard.component.clojure.config.model.ClojureScriptModel;
import org.switchyard.exception.SwitchYardException;

public class ClojureHandler
implements ExchangeHandler {
    private final ClojureComponentImplementationModel _implModel;
    private Var _var;

    public ClojureHandler(ClojureComponentImplementationModel implModel) {
        this._implModel = implModel;
    }

    public void start(ServiceReference serviceReference) throws Exception {
        try {
            ClojureScriptModel scriptModel = this._implModel.getScriptModel();
            this._var = scriptModel != null ? (Var)Compiler.load(new StringReader(scriptModel.getScript())) : (Var)Compiler.load(this.loadInputStream(this._implModel.getScriptFile()));
        }
        catch (Exception e2) {
            throw new SwitchYardException((Throwable)e2);
        }
    }

    private InputStreamReader loadInputStream(String scriptFile) throws IOException {
        InputStream in = Classes.getResourceAsStream((String)scriptFile);
        if (in != null) {
            return new InputStreamReader(in);
        }
        return new InputStreamReader(new FileInputStream(scriptFile));
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        try {
            Object response;
            Object object = response = this._implModel.injectExchange() != false ? this._var.invoke(exchange) : this._var.invoke(exchange.getMessage().getContent());
            if (response != null) {
                exchange.getMessage().setContent(response);
                exchange.send(exchange.getMessage());
            }
        }
        catch (Exception e2) {
            throw new HandlerException((Throwable)e2);
        }
    }

    public void handleFault(Exchange exchange) {
    }
}

