/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.clojure.deploy;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.clojure.config.model.ClojureComponentImplementationModel;
import org.switchyard.component.clojure.deploy.ClojureHandler;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.exception.SwitchYardException;

public class ClojureActivator
extends BaseActivator {
    private static final String[] TYPES = new String[]{"clojure"};
    private Map<QName, ClojureHandler> _handlers = new HashMap<QName, ClojureHandler>();

    public ClojureActivator() {
        super(TYPES);
    }

    public ExchangeHandler init(QName name2, Model config) {
        if (this.isComponentService(config)) {
            return this.handleImplemenation(config, name2);
        }
        return null;
    }

    private ClojureHandler handleImplemenation(Model model, QName serviceName) {
        ComponentImplementationModel implModel = this.getComponentImplementationModel(model);
        if (implModel instanceof ClojureComponentImplementationModel) {
            ClojureHandler clojureHandler = new ClojureHandler((ClojureComponentImplementationModel)implModel);
            this._handlers.put(serviceName, clojureHandler);
            return clojureHandler;
        }
        return null;
    }

    private boolean isComponentService(Model config) {
        return config instanceof ComponentServiceModel;
    }

    private ComponentImplementationModel getComponentImplementationModel(Model config) {
        Model modelParent = ((ComponentServiceModel)config).getModelParent();
        ComponentModel componentModel = (ComponentModel)modelParent;
        return componentModel.getImplementation();
    }

    public void start(ServiceReference service) {
        for (ClojureHandler handler : this._handlers.values()) {
            try {
                handler.start(service);
            }
            catch (Exception e2) {
                throw new SwitchYardException((Throwable)e2);
            }
        }
    }

    public void stop(ServiceReference service) {
    }

    public void destroy(ServiceReference service) {
    }
}

