/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.clojure;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.clojure.config.model.ClojureComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.forge.clojure.ClojureBuilderException;
import org.switchyard.tools.forge.clojure.ClojureFacet;
import org.switchyard.tools.forge.clojure.ClojureModelBuilder;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;

@Alias(value="clojure-service")
@Topic(value="SOA")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, ClojureFacet.class})
@Help(value="Provides commands to create Clojure services in SwitchYard.")
public class ClojureImplementationPlugin
implements Plugin {
    @Inject
    private Project _project;

    @Command(value="create", help="Create a new implemenation.clojure")
    public void newImplementation(@Option(required=true, name="serviceName", shortName="s", description="The service name", help="The SwitchYard service name to use for this implementation") String serviceName, @Option(name="inlineScript", shortName="i", description="Use inline Clojure script", help="Path to the Clojure script to inline, the content will be placed into the script element") String inlineScript, @Option(name="emptyInlineScript", flagOnly=true, description="Creates an empty 'script' element", help="An empty 'script' element will be created that can be filled in later.") boolean emptyInlineScript, @Option(name="externalScriptPath", shortName="e", description="Path to the external Clojure Script", help="Path to the external Clojure script to be referenced from the 'scriptFile' attribute") String externalScriptPath, @Option(name="emptyExternalScriptPath", flagOnly=true, description="Creates an empty 'scriptFile' attribute", help="An empty 'scriptFile' attribute will be created that can be filled in later.") boolean emptyExternalScriptPath, @Option(name="injectExchange", shortName="x", flagOnly=true, description="Inject the SwitchYard Exchange object into the Clojure script", help="The SwitchYard Exchange will be injected into the Clojure script if this value is set. If not, only the Message content will be injected.") boolean injectExchange, PipeOut out) {
        ClojureComponentImplementationModel impl = this.createImplModel(inlineScript, emptyInlineScript, externalScriptPath, emptyExternalScriptPath, injectExchange);
        V1ComponentModel component = this.createComponentModel(serviceName);
        component.setImplementation((ComponentImplementationModel)impl);
        this.saveSwitchYardModel(component);
        out.println("Created Clojure implementation " + serviceName);
    }

    private ClojureComponentImplementationModel createImplModel(String inlineScript, boolean emptyInlineScript, String externalScriptPath, boolean emptyExternalScriptPath, boolean injectExchange) {
        try {
            return new ClojureModelBuilder().inlineScript(inlineScript).emptyInlineScript(emptyInlineScript).externalScriptPath(externalScriptPath).emptyExternalScriptPath(emptyExternalScriptPath).injectExchange(injectExchange).build();
        }
        catch (ClojureBuilderException e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    private void saveSwitchYardModel(V1ComponentModel component) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        SwitchYardModel syConfig = switchYard.getSwitchYardConfig();
        syConfig.getComposite().addComponent((ComponentModel)component);
        switchYard.saveConfig();
    }

    private V1ComponentModel createComponentModel(String serviceName) {
        V1ComponentModel component = new V1ComponentModel();
        component.setName(serviceName + "Component");
        V1ComponentServiceModel service = new V1ComponentServiceModel();
        service.setName(serviceName);
        component.addService((ComponentServiceModel)service);
        return component;
    }
}

