/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.forge.hornetq;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.switchyard.component.hornetq.config.model.v1.V1ConnectorConfigModel;
import org.switchyard.component.hornetq.config.model.v1.V1HornetQBindingModel;
import org.switchyard.component.hornetq.config.model.v1.V1HornetQConfigModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.tools.forge.common.CommonFacet;
import org.switchyard.tools.forge.hornetq.HornetQFacet;
import org.switchyard.tools.forge.plugin.SwitchYardFacet;

@Alias(value="hornetq-binding")
@RequiresProject
@RequiresFacet(value={SwitchYardFacet.class, CommonFacet.class, HornetQFacet.class})
@Topic(value="SOA")
@Help(value="Provides commands to manage HornetQ service bindings in SwitchYard.")
public class HornetQBindingPlugin
implements Plugin {
    @Inject
    private Project _project;

    @Command(value="bind-service", help="Add a HornetQ binding to a service.")
    public void bindService(@Option(required=true, name="serviceName", description="The service name") String serviceName, @Option(required=true, name="queueName", description="The queue name") String queueName, @Option(required=false, name="factoryClass", defaultValue="org.hornetq.core.remoting.impl.invm.InVMConnectorFactory", description="The ConnectorFactory class name") String factoryClass, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeServiceModel service = switchYard.getCompositeService(serviceName);
        if (service == null) {
            out.println(out.renderColor(ShellColor.RED, "No public service named: " + serviceName));
            return;
        }
        V1HornetQBindingModel binding = new V1HornetQBindingModel();
        V1HornetQConfigModel config = new V1HornetQConfigModel();
        V1ConnectorConfigModel connector = new V1ConnectorConfigModel();
        connector.setConnectorClassName(factoryClass);
        config.setConnectorConfiguration(connector);
        config.setQueue(queueName);
        binding.setHornetQConfig(config);
        service.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.hornetq to service " + serviceName);
    }

    @Command(value="bind-reference", help="Add a SOAP binding to a reference.")
    public void bindReference(@Option(required=true, name="referenceName", description="The reference name") String referenceName, @Option(required=true, name="queueName", description="The queue name") String queueName, @Option(required=false, name="factoryClass", defaultValue="org.hornetq.core.remoting.impl.invm.InVMConnectorFactory", description="The ConnectorFactory class name") String factoryClass, PipeOut out) {
        SwitchYardFacet switchYard = (SwitchYardFacet)this._project.getFacet(SwitchYardFacet.class);
        CompositeReferenceModel reference = switchYard.getCompositeReference(referenceName);
        if (reference == null) {
            out.println(out.renderColor(ShellColor.RED, "No public reference named: " + referenceName));
            return;
        }
        V1HornetQBindingModel binding = new V1HornetQBindingModel();
        V1HornetQConfigModel config = new V1HornetQConfigModel();
        V1ConnectorConfigModel connector = new V1ConnectorConfigModel();
        connector.setConnectorClassName(factoryClass);
        config.setConnectorConfiguration(connector);
        config.setQueue(queueName);
        binding.setHornetQConfig(config);
        reference.addBinding((BindingModel)binding);
        switchYard.saveConfig();
        out.println("Added binding.hornetq to reference " + referenceName);
    }
}

