/*
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.switchyard.component.jca.config.model;

import org.switchyard.config.model.Model;
/**
 * sca property model.
 * 
 * @author <a href="mailto:tm.igarashi@gmail.com">Tomohisa Igarashi</a>
 *
 */
public interface PropertyModel extends Model {
    
    /**
     * get property name.
     * 
     * @return name
     */
    String getName();
    
    /**
     * set property name.
     * 
     * @param name name to set
     * @return {@link PropertyModel} to support method chaining
     */
    PropertyModel setName(String name);
    
    /**
     * get property value.
     * 
     * @return value
     */
    String getValue();
    
    /**
     * set property value.
     * 
     * @param value value to set
     * @return {@link PropertyModel} to support method chaining
     */
    PropertyModel setValue(String value);
}
