/*
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.switchyard.karaf.test.quickstarts.demo;

import static org.ops4j.pax.exam.karaf.options.KarafDistributionOption.features;

import org.junit.BeforeClass;
import org.ops4j.pax.exam.CoreOptions;
import org.switchyard.karaf.test.quickstarts.AbstractQuickstartTest;

public class PolicyTransactionDemoQuickstartTest extends AbstractQuickstartTest {
    private static String bundleName = "org.switchyard.quickstarts.demos.switchyard.demo.policy.transaction";
    private static String featureName = "switchyard-demo-policy-transaction";
    private static String[] extraFeatures = {"activemq-broker-noweb"};

    @BeforeClass
    public static void before() throws Exception {
        startTestContainer(featureName, bundleName,
                CoreOptions.options(features(
                        CoreOptions.maven().groupId("org.apache.activemq").artifactId("activemq-karaf").type("xml").classifier("features").versionAsInProject().getURL(),
                        extraFeatures)));
    }
}
