/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.BaseSwitchYardResourceComponent;
import org.switchyard.rhq.plugin.SwitchYardResourceComponent;
import org.switchyard.rhq.plugin.model.Application;
import org.switchyard.rhq.plugin.model.ComponentService;
import org.switchyard.rhq.plugin.model.ComponentServiceMetrics;
import org.switchyard.rhq.plugin.model.Reference;
import org.switchyard.rhq.plugin.model.ReferenceMetrics;
import org.switchyard.rhq.plugin.model.Service;
import org.switchyard.rhq.plugin.model.ServiceMetrics;

public class ApplicationResourceComponent
extends BaseSwitchYardResourceComponent<SwitchYardResourceComponent> {
    private static Log LOG = LogFactory.getLog(ApplicationResourceComponent.class);

    @Override
    protected Log getLog() {
        return LOG;
    }

    public AvailabilityType getAvailability() {
        Application application = this.getApplication();
        return application == null ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    public Map<String, Service> getServices() {
        Application application = this.getApplication();
        if (application == null) {
            return Collections.emptyMap();
        }
        return application.getServices();
    }

    public Map<String, Reference> getReferences() {
        Application application = this.getApplication();
        if (application == null) {
            return Collections.emptyMap();
        }
        return application.getReferences();
    }

    public Map<String, ComponentService> getComponentServices() {
        Application application = this.getApplication();
        if (application == null) {
            return Collections.emptyMap();
        }
        return application.getComponentServices();
    }

    public Application getApplication() {
        String applicationKey = this.getResourceContext().getResourceKey();
        return ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).getApplication(applicationKey);
    }

    public <T> T execute(Operation operation, Class<T> clazz) {
        return ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).execute(operation, clazz);
    }

    public Map<String, ServiceMetrics> getServiceMetrics() {
        String applicationKey = this.getResourceContext().getResourceKey();
        Map<String, Map<String, ServiceMetrics>> serviceMetricsMap = ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).getServiceMetrics();
        return serviceMetricsMap.get(applicationKey);
    }

    public Map<String, ReferenceMetrics> getReferenceMetrics() {
        String applicationKey = this.getResourceContext().getResourceKey();
        Map<String, Map<String, ReferenceMetrics>> referenceMetricsMap = ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).getReferenceMetrics();
        return referenceMetricsMap.get(applicationKey);
    }

    public Map<String, ComponentServiceMetrics> getComponentServiceMetrics() {
        String applicationKey = this.getResourceContext().getResourceKey();
        Map<String, Map<String, ComponentServiceMetrics>> componentServiceMetricsMap = ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).getComponentServiceMetrics();
        return componentServiceMetricsMap.get(applicationKey);
    }

    public void clearApplications() {
        ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).clearApplications();
    }

    public void clearServiceMetrics() {
        ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).clearServiceMetrics();
    }

    public void clearReferenceMetrics() {
        ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).clearReferenceMetrics();
    }

    public void clearComponentServiceMetrics() {
        ((SwitchYardResourceComponent)this.getResourceContext().getParentResourceComponent()).clearComponentServiceMetrics();
    }
}

